/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.stardust.ide.simulation.ui.timeutils.ClassifiedTimestampList;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampComparator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;

public class TimestampValueList {
    public static final double EPS = 0.001;
    List impl = new ArrayList();

    public TimestampValue get(int index) {
        return (TimestampValue)this.impl.get(index);
    }

    public TimestampValue getFirst() {
        return (TimestampValue)this.impl.get(0);
    }

    public TimestampValue getLast() {
        return (TimestampValue)this.impl.get(this.impl.size() - 1);
    }

    public void prepend(TimestampValue t) {
        this.impl.add(0, t);
    }

    public void add(TimestampValue t) {
        this.impl.add(t);
    }

    public void remove(TimestampValue t) {
        this.impl.remove(t);
    }

    public void addAll(TimestampValueList list) {
        TreeSet sort = new TreeSet(new TimestampComparator());
        sort.addAll(this.impl);
        sort.addAll(list.impl);
        this.impl.clear();
        this.impl.addAll(sort);
    }

    public void addAll(TimestampValue[] array) {
        this.impl.addAll(Arrays.asList(array));
    }

    public int size() {
        return this.impl.size();
    }

    public TimestampValue[] toArray() {
        return this.impl.toArray(new TimestampValue[this.size()]);
    }

    public double averageValue() {
        if (this.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        int n = 0;
        while (n < this.size()) {
            sum += this.get((int)n).value;
            ++n;
        }
        return sum / (double)this.size();
    }

    public double weightedAverageValue() {
        if (this.size() == 0) {
            return 0.0;
        }
        TimestampValue previousTV = this.get(0);
        double square = 0.0;
        int n = 1;
        while (n < this.size()) {
            TimestampValue currentTV = this.get(n);
            square += (double)(currentTV.time - previousTV.time) * previousTV.value;
            previousTV = currentTV;
            ++n;
        }
        double range = this.get((int)(this.size() - 1)).time - this.get((int)0).time;
        return range > 0.0 ? square / range : 0.0;
    }

    public double minValue() {
        if (this.size() == 0) {
            return 0.0;
        }
        double result = this.get((int)0).value;
        int n = 1;
        while (n < this.size()) {
            result = Math.min(result, this.get((int)n).value);
            ++n;
        }
        return result;
    }

    public double maxValue() {
        if (this.size() == 0) {
            return 0.0;
        }
        double result = this.get((int)0).value;
        int n = 1;
        while (n < this.size()) {
            result = Math.max(result, this.get((int)n).value);
            ++n;
        }
        return result;
    }

    public double valueAt(long time) {
        if (this.size() == 0 || time < this.get((int)0).time) {
            return 0.0;
        }
        int index = 1;
        while (index < this.size() && time > this.get((int)index).time) {
            ++index;
        }
        return this.get((int)(index - 1)).value;
    }

    public TimestampValueList shift(long millis) {
        TimestampValueList result = new TimestampValueList();
        int i = 0;
        while (i < this.size()) {
            result.add((TimestampValue)this.get(i).shift(millis));
            ++i;
        }
        return result;
    }

    public ClassifiedTimestampList[] groupByTimePeriod(ClassifiedTimestampList[] result) {
        return this.groupByTimePeriod(result, true);
    }

    public ClassifiedTimestampList[] groupByTimePeriod(ClassifiedTimestampList[] result, boolean closeIntervals) {
        if (this.size() > 0) {
            if (closeIntervals && this.get((int)0).time > result[0].interval.getStartTimestamp().time) {
                result[0].add(new TimestampValue(result[0].interval.getStartTimestamp(), 0.0));
            }
            int i = 0;
            while (i < this.size()) {
                TimestampValue currentTV = this.get(i);
                int currentIndex = TimestampValueList.findIndex(currentTV, result);
                result[currentIndex].add(currentTV);
                if (closeIntervals) {
                    if (i + 1 < this.size()) {
                        TimestampValue nextTV = this.get(i + 1);
                        int nextIndex = TimestampValueList.findIndex(nextTV, result);
                        if (currentIndex != nextIndex) {
                            result[currentIndex].add(new TimestampValue(result[currentIndex].interval.getEndTimestamp().time, currentTV.value));
                            int k = currentIndex + 1;
                            while (k <= nextIndex - 1) {
                                result[k].add(new TimestampValue(result[k].interval.getStartTimestamp().time, currentTV.value));
                                result[k].add(new TimestampValue(result[k].interval.getEndTimestamp().time, currentTV.value));
                                ++k;
                            }
                            result[nextIndex].add(new TimestampValue(result[nextIndex].interval.getStartTimestamp().time, currentTV.value));
                        }
                    } else if (currentTV.time < result[currentIndex].interval.getEndTimestamp().time) {
                        result[currentIndex].add(new TimestampValue(result[currentIndex].interval.getEndTimestamp(), currentTV.value));
                    }
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static int findIndex(Timestamp t, ClassifiedTimestampList[] grid) {
        index = grid.length - 1;
        if (grid[index].interval.time >= t.time) ** GOTO lbl5
        return index;
lbl-1000:
        // 1 sources

        {
            --index;
lbl5:
            // 2 sources

            ** while (index > 0 && t.time < grid[index].interval.time)
        }
lbl6:
        // 1 sources

        return index;
    }

    public TimestampValueList getNonZeroValues() {
        TimestampValueList result = new TimestampValueList();
        int i = 0;
        while (i < this.size()) {
            if (this.get((int)i).value > 0.001) {
                result.add(this.get(i));
            }
            ++i;
        }
        return result;
    }

    public double sumTime() {
        double result = 0.0;
        int n = 0;
        while (n < this.size()) {
            result += (double)this.get((int)n).time;
            ++n;
        }
        return result;
    }

    public double sumValue() {
        double result = 0.0;
        int n = 0;
        while (n < this.size()) {
            result += this.get((int)n).value;
            ++n;
        }
        return result;
    }

    public double sumTimeCrossValue() {
        double result = 0.0;
        int n = 0;
        while (n < this.size()) {
            result += (double)this.get((int)n).time * this.get((int)n).value;
            ++n;
        }
        return result;
    }

    public double sumTimeSqr() {
        double result = 0.0;
        int n = 0;
        while (n < this.size()) {
            result += (double)(this.get((int)n).time * this.get((int)n).time);
            ++n;
        }
        return result;
    }

    public String toString() {
        return "SIZE: " + this.size() + "\nVALUES: " + this.impl.toString();
    }
}

