/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.Date;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampHelper;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueList;

public abstract class TimestampValueListApproximation {
    Date targetStartDate;
    Date targetEndDate;

    public abstract TimestampValueList transpose(TimestampValueList var1, int var2);

    public void setTargetInterval(Date targetStartDate, Date targetEndDate) {
        this.targetStartDate = targetStartDate;
        this.targetEndDate = targetEndDate;
    }

    public TimestampValueList createEmptyCurve() {
        TimestampValueList resultAbsolute = new TimestampValueList();
        resultAbsolute.add(new TimestampValue(0L, 0.0));
        resultAbsolute.add(new TimestampValue(this.targetEndDate.getTime() - this.targetStartDate.getTime(), 0.0));
        return resultAbsolute;
    }

    public static class Continue
    extends TimestampValueListApproximation {
        @Override
        public TimestampValueList transpose(TimestampValueList curve, int calendarUnit) {
            if (curve.size() > 0) {
                TimestampValueList continousCurve = new TimestampValueList();
                TimestampValue oldStart = curve.getFirst();
                Timestamp newPos = new Timestamp(this.targetStartDate);
                Timestamp newEnd = new Timestamp(this.targetEndDate);
                continousCurve.addAll(curve);
                while (continousCurve.getLast().time < newEnd.time) {
                    newPos = continousCurve.getLast();
                    continousCurve.remove(continousCurve.getLast());
                    continousCurve.addAll(curve.shift(newPos.time - oldStart.time));
                }
                Timestamp newStart = new Timestamp(this.targetStartDate);
                TimestampValueList resultFromTarget = new TimestampValueList();
                resultFromTarget.add(new TimestampValue(newStart, continousCurve.valueAt(newStart.time)));
                int i = 0;
                while (i < continousCurve.size()) {
                    if (continousCurve.get((int)i).time <= newStart.time || continousCurve.get((int)i).time < newEnd.time) {
                        // empty if block
                    }
                    resultFromTarget.add(continousCurve.get(i));
                    ++i;
                }
                resultFromTarget.add(new TimestampValue(newEnd, continousCurve.valueAt(newEnd.time)));
                return resultFromTarget.shift(-newStart.time);
            }
            return this.createEmptyCurve();
        }
    }

    public static class Linear
    extends TimestampValueListApproximation {
        @Override
        public TimestampValueList transpose(TimestampValueList curve, int calendarUnit) {
            TimestampValueList nonZeroCurve = curve.getNonZeroValues();
            if (nonZeroCurve.size() > 1) {
                TimestampValueList resultFromTarget = new TimestampValueList();
                double n = nonZeroCurve.size();
                double sumX = nonZeroCurve.sumTime();
                double sumY = nonZeroCurve.sumValue();
                double sumXxY = nonZeroCurve.sumTimeCrossValue();
                double sumXxX = nonZeroCurve.sumTimeSqr();
                double denominator = sumX * sumX - n * sumXxX;
                double a = (sumX * sumY - n * sumXxY) / denominator;
                double b = (sumX * sumXxY - sumY * sumXxY) / denominator;
                Interval[] newCurveTimes = TimestampHelper.createGrid(calendarUnit, this.targetStartDate.getTime(), this.targetEndDate.getTime());
                int i = 0;
                while (i < newCurveTimes.length) {
                    resultFromTarget.add(new TimestampValue(newCurveTimes[i].time, a * (double)newCurveTimes[i].time + b));
                    ++i;
                }
                Timestamp newStart = new Timestamp(this.targetStartDate);
                return resultFromTarget.shift(-newStart.time);
            }
            return this.createEmptyCurve();
        }
    }

    public static class Repeate
    extends TimestampValueListApproximation {
        @Override
        public TimestampValueList transpose(TimestampValueList curve, int calendarUnit) {
            if (curve.size() > 0) {
                TimestampValueList resultFromTarget = new TimestampValueList();
                TimestampValue oldStart = curve.getFirst();
                Timestamp newPos = new Timestamp(this.targetStartDate);
                Timestamp newEnd = new Timestamp(this.targetEndDate);
                resultFromTarget.addAll(curve.shift(newPos.time - oldStart.time));
                while (resultFromTarget.getLast().time < newEnd.time) {
                    newPos = resultFromTarget.getLast();
                    resultFromTarget.remove(resultFromTarget.getLast());
                    resultFromTarget.addAll(curve.shift(newPos.time - oldStart.time));
                }
                while (resultFromTarget.getLast().time >= newEnd.time) {
                    resultFromTarget.remove(resultFromTarget.getLast());
                }
                if (resultFromTarget.getLast().time <= newEnd.time) {
                    TimestampValue terminationPoint = new TimestampValue(newEnd, 0.0);
                    resultFromTarget.add(terminationPoint);
                }
                Timestamp newStart = new Timestamp(this.targetStartDate);
                return resultFromTarget.shift(-newStart.time);
            }
            return this.createEmptyCurve();
        }
    }
}

