/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractRetrievableSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DataValueGeneratorConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DurationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.ProbabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.CurveMerger;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.CurveUtils;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelVisitable;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;

public class SimulationConfigurationValidator
implements IModelElementValidator,
ModelVisitor {
    SimulationConfiguration simulationConfiguration;
    List issues = new ArrayList();

    public Issue[] validate(IModelElement element) throws ValidationException {
        this.issues = new ArrayList();
        this.simulationConfiguration = this.getActiveSimulationConfiguration(element);
        if (this.simulationConfiguration != null) {
            new ModelVisitable(element).accept(this);
        }
        return this.issues.isEmpty() ? null : this.getIssues();
    }

    @Override
    public void visit(ModelType model) {
    }

    @Override
    public void visit(ProcessDefinitionType element) {
        AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.simulationConfiguration.getInterval());
        configuration.read((IExtensibleElement)element, this.simulationConfiguration.getId());
        long overflowOffset = CurveUtils.findOverflow(configuration.getYear(), 100000.0);
        if (overflowOffset >= 0L) {
            Date overflowDate = new Date(this.simulationConfiguration.getInterval().getStartDate().getTime() + overflowOffset);
            this.issues.add(Issue.warning((EObject)element, (String)MessageFormat.format(Simulation_Modeling_Messages.MSG_ARRIVAL_RATE_GT, overflowDate), (Object)ValidationService.PKG_CWM.getProcessDefinitionType()));
        }
        if (!configuration.isComplete()) {
            this.issues.add(Issue.warning((EObject)element, (String)Simulation_Modeling_Messages.MSG_CONFIGURATION_IS_NOT_COMPLETE, (Object)ValidationService.PKG_CWM.getProcessDefinitionType()));
        }
    }

    @Override
    public void visit(ActivityType element) {
        boolean applicationWithDuration;
        if (element.getOutTransitions().size() > 0) {
            ProbabilityConfiguration[] configurations = new ProbabilityConfiguration[element.getOutTransitions().size()];
            int i = 0;
            long curveLength = this.simulationConfiguration.getInterval().getDurationInMillis();
            for (TransitionType transition : element.getOutTransitions()) {
                configurations[i] = new ProbabilityConfiguration(this.simulationConfiguration.getInterval(), 1.0);
                configurations[i].read((IExtensibleElement)transition, this.simulationConfiguration.getId());
                ++i;
            }
            int j = 0;
            while (j < configurations.length) {
                CurveMerger mergeOne = new CurveMerger(configurations[j].getCurve(), curveLength);
                mergeOne.addMultiplier(configurations[j].getMultiplicatorCurve(), curveLength);
                long overflowOffset = CurveUtils.findOverflow(mergeOne.merge(), 100.0);
                if (overflowOffset >= 0L) {
                    Date overflowDate = new Date(this.simulationConfiguration.getInterval().getStartDate().getTime() + overflowOffset);
                    this.issues.add(Issue.error((EObject)((IModelElement)element.getOutTransitions().get(j)), (String)MessageFormat.format(Simulation_Modeling_Messages.MSG_PROBABILITY_GT_100, overflowDate), (Object)ValidationService.PKG_CWM.getTransitionType_To()));
                }
                ++j;
            }
            if (element.getOutTransitions().size() > 1 && element.getSplit().equals((Object)JoinSplitType.XOR_LITERAL)) {
                CurveMerger addAll = null;
                int j2 = 0;
                while (j2 < configurations.length) {
                    CurveMerger mergeOne = new CurveMerger(configurations[j2].getCurve(), curveLength);
                    mergeOne.addMultiplier(configurations[j2].getMultiplicatorCurve(), curveLength);
                    if (addAll == null) {
                        addAll = new CurveMerger(mergeOne.merge(), curveLength);
                    } else {
                        addAll.addMultiplier(mergeOne.merge(), curveLength);
                    }
                    ++j2;
                }
                long overflowOffset = CurveUtils.findOverflow(addAll.add(), 100.0);
                if (overflowOffset >= 0L) {
                    Date overflowDate = new Date(this.simulationConfiguration.getInterval().getStartDate().getTime() + overflowOffset);
                    this.issues.add(Issue.error((EObject)element, (String)MessageFormat.format(Simulation_Modeling_Messages.MSG_TOTAL_PROBABILITY_GT_100, overflowDate), (Object)ValidationService.PKG_CWM.getTransitionType_To()));
                }
            }
        }
        ActivityImplementationType implementation = element.getImplementation();
        ApplicationType application = element.getApplication();
        boolean activityWithDuration = implementation != null && (implementation.getValue() == 1 || implementation.getValue() == 0);
        boolean bl = applicationWithDuration = application != null && application.isInteractive();
        if (activityWithDuration || applicationWithDuration) {
            DurationConfiguration configuration = new DurationConfiguration(this.simulationConfiguration.getInterval());
            configuration.read((IExtensibleElement)element, this.simulationConfiguration.getId());
            if (!configuration.isComplete()) {
                this.issues.add(Issue.warning((EObject)element, (String)Simulation_Modeling_Messages.MSG_CONFIGURATION_IS_NOT_COMPLETE, (Object)ValidationService.PKG_CWM.getActivityType()));
            }
        }
    }

    @Override
    public void visit(ApplicationType element) {
        AbstractRetrievableSimulationSubConfiguration configuration;
        if (!element.isInteractive()) {
            configuration = new AvailabilityConfiguration(this.simulationConfiguration.getInterval());
            configuration.read((IExtensibleElement)element, this.simulationConfiguration.getId());
            if (!((AvailabilityConfiguration)configuration).isComplete()) {
                this.issues.add(Issue.warning((EObject)element, (String)Simulation_Modeling_Messages.MSG_CONFIGURATION_IS_NOT_COMPLETE, (Object)ValidationService.PKG_CWM.getApplicationType()));
            }
        }
        configuration = new DurationConfiguration(this.simulationConfiguration.getInterval());
        configuration.read((IExtensibleElement)element, this.simulationConfiguration.getId());
        if (!configuration.isComplete()) {
            this.issues.add(Issue.warning((EObject)element, (String)Simulation_Modeling_Messages.MSG_CONFIGURATION_IS_NOT_COMPLETE, (Object)ValidationService.PKG_CWM.getApplicationType()));
        }
    }

    @Override
    public void visit(IModelParticipant element) {
        AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.simulationConfiguration.getInterval());
        configuration.read((IExtensibleElement)element, this.simulationConfiguration.getId());
        if (!configuration.isComplete()) {
            this.issues.add(Issue.warning((EObject)element, (String)Simulation_Modeling_Messages.MSG_CONFIGURATION_IS_NOT_COMPLETE, (Object)ValidationService.PKG_CWM.getParticipantType()));
        }
    }

    @Override
    public void visit(TransitionType element) {
        ProbabilityConfiguration configuration = new ProbabilityConfiguration(this.simulationConfiguration.getInterval(), SimulationModelUtils.calculateDefaultProbability((IModelElement)element));
        configuration.read((IExtensibleElement)element, this.simulationConfiguration.getId());
        if (!configuration.isComplete()) {
            this.issues.add(Issue.warning((EObject)element, (String)Simulation_Modeling_Messages.MSG_CONFIGURATION_IS_NOT_COMPLETE, (Object)ValidationService.PKG_CWM.getTransitionType()));
        }
    }

    @Override
    public void visit(DataType element) {
        DataValueGeneratorConfiguration configuration = new DataValueGeneratorConfiguration(this.simulationConfiguration.getInterval());
        configuration.read((IExtensibleElement)element, this.simulationConfiguration.getId());
        if (configuration.getDataTypeClassId() != null) {
            if (!configuration.getDataTypeClassId().equals(DataValueGeneratorConfiguration.retrieveDataTypeClass(element))) {
                this.issues.add(Issue.warning((EObject)element, (String)MessageFormat.format(Simulation_Modeling_Messages.MSG_INVALID_DATA_GENERATOR, DataValueGeneratorConfiguration.retrieveDataTypeClass(element)), (Object)ValidationService.PKG_CWM.getDataType()));
            } else if (!configuration.isComplete()) {
                this.issues.add(Issue.warning((EObject)element, (String)Simulation_Modeling_Messages.MSG_CONFIGURATION_IS_NOT_COMPLETE, (Object)ValidationService.PKG_CWM.getDataType()));
            }
        }
    }

    public SimulationConfiguration getActiveSimulationConfiguration(IModelElement element) {
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        AttributeType configurationIdAttr = AttributeUtil.getAttribute((IExtensibleElement)model, (String)"carnot:simulation:configuration:currentSimulationConfigurationId");
        if (configurationIdAttr != null) {
            return new SimulationConfiguration(Integer.parseInt(configurationIdAttr.getAttributeValue()), model);
        }
        return null;
    }

    private Issue[] getIssues() {
        return this.issues.toArray(new Issue[this.issues.size()]);
    }
}

