/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.platform.utils;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;

public class WorkspaceUtils {
    public static String resolveAbsolutePath(String projectName, String resourcePath) {
        IResource resource;
        IProject wspProject;
        IWorkspaceRoot wspRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (wspRoot != null && projectName != null && (wspProject = wspRoot.getProject(projectName)) != null && resourcePath != null && (resource = wspProject.findMember(resourcePath)) != null) {
            return resource.getLocation().toFile().getAbsolutePath();
        }
        return null;
    }

    public static String getLocation(ModelType model) {
        String projectName = null;
        String modelFilePath = null;
        Resource eResource = model.eResource();
        if (eResource != null) {
            URI eUri = eResource.getURI();
            if (!eUri.isPlatform()) {
                return eUri.toFileString();
            }
            URI projectUri = eUri.trimSegments(eUri.segmentCount() - 2);
            URI modelUri = eUri.deresolve(projectUri);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(eUri.segment(1));
            IProject project = null;
            if (resource instanceof IProject) {
                project = (IProject)resource;
            } else if (resource != null) {
                project = resource.getProject();
            }
            if (project != null) {
                projectName = project.getName();
                modelFilePath = modelUri.toString();
                if (modelFilePath.startsWith(String.valueOf(projectName) + "/")) {
                    modelFilePath = modelFilePath.substring(projectName.length() + 1);
                }
            }
        }
        if (modelFilePath == null || projectName == null) {
            return null;
        }
        return WorkspaceUtils.resolveAbsolutePath(projectName, modelFilePath);
    }

    public static IProject getProjectFromEObject(EObject eObject) {
        Resource eResource;
        ContextType contextType;
        if (eObject instanceof ContextType && (contextType = (ContextType)eObject).getType() != null) {
            eObject = contextType.getType().eContainer();
        }
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            URI eUri = eResource.getURI();
            if (eUri.isFile()) {
                String fileString = eUri.toFileString();
                java.net.URI netModelUri = new File(fileString).toURI();
                IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(netModelUri);
                if (containers != null && containers.length > 0) {
                    IContainer container = containers[0];
                    return container.getProject();
                }
            }
            if (eUri.segmentCount() > 1) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(eUri.segment(1));
                if (resource instanceof IProject) {
                    return (IProject)resource;
                }
                if (resource != null) {
                    return resource.getProject();
                }
            }
        }
        return null;
    }

    private WorkspaceUtils() {
    }
}

