/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public class ToggleBpmNatureAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    public static final String NATURE_ID = "org.eclipse.stardust.modeling.common.projectnature.carnotBusinessProcessManagement";
    private final Set<IProject> projects = new HashSet<IProject>();

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.updateSelectedProjects(selection);
        boolean enabled = false;
        boolean checked = false;
        if (1 == this.projects.size()) {
            enabled = true;
            IProject project = this.projects.iterator().next();
            try {
                checked = project.isOpen() && project.hasNature(NATURE_ID);
            }
            catch (CoreException coreException) {
                enabled = false;
            }
        }
        action.setEnabled(enabled);
        action.setChecked(checked);
    }

    public void run(IAction action) {
        for (IProject project : this.projects) {
            if (!project.isOpen()) continue;
            try {
                IProjectDescription prjDescr = project.getDescription();
                ArrayList<String> ids = new ArrayList<String>(prjDescr.getNatureIds().length + 1);
                ids.addAll(Arrays.asList(prjDescr.getNatureIds()));
                if (ids.contains(NATURE_ID)) {
                    ids.remove(NATURE_ID);
                } else {
                    ids.add(0, NATURE_ID);
                }
                prjDescr.setNatureIds(ids.toArray(StringUtils.EMPTY_STRING_ARRAY));
                project.setDescription(prjDescr, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateSelectedProjects(ISelection selection) {
        this.projects.clear();
        if (selection instanceof IStructuredSelection) {
            for (Object item : (IStructuredSelection)selection) {
                if (!(item instanceof IResource) && item instanceof IAdaptable) {
                    item = ((IAdaptable)item).getAdapter(IResource.class);
                }
                if (!(item instanceof IProject) && item instanceof IResource) {
                    item = ((IResource)item).getProject();
                }
                if (!(item instanceof IProject)) continue;
                this.projects.add((IProject)item);
            }
        }
    }
}

