/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.classpath;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmClasspathUtils;
import org.eclipse.stardust.modeling.common.projectnature.classpath.CarnotWorkLocationClasspathContainer;
import org.eclipse.stardust.modeling.common.ui.UI_Messages;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;

public class CarnotWorkClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage {
    private String initialValue;
    private LabeledText txtWorkFolder;

    public CarnotWorkClasspathContainerPage() {
        super(UI_Messages.STR_WorkLocation);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        String workFolder = null;
        if (this.txtWorkFolder != null && !this.txtWorkFolder.getText().isDisposed()) {
            workFolder = this.txtWorkFolder.getText().getText();
        }
        IPath entryPath = BpmClasspathUtils.encodeClasspathEntryHint((IPath)CarnotWorkLocationClasspathContainer.PATH_CARNOT_WORK_LOCATION_CP, workFolder);
        return JavaCore.newContainerEntry((IPath)entryPath);
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.initialValue = containerEntry != null ? BpmClasspathUtils.retrieveEncodedClasspathEntryHint((IPath)containerEntry.getPath()) : null;
    }

    public void createControl(Composite parent) {
        Composite panel = FormBuilder.createComposite((Composite)parent, (int)3);
        this.txtWorkFolder = FormBuilder.createLabeledText((Composite)panel, (String)UI_Messages.LB_WorkLocation);
        FormBuilder.createButton((Composite)panel, (String)UI_Messages.BTN_Browse, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CarnotWorkClasspathContainerPage.this.browseForFile(CarnotWorkClasspathContainerPage.this.txtWorkFolder.getText());
            }
        });
        this.txtWorkFolder.getText().setText(!StringUtils.isEmpty((String)this.initialValue) ? this.initialValue : "");
        this.setControl((Control)panel);
    }

    protected void browseForFile(Text txtTarget) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setFilterPath(txtTarget.getText());
        String directory = dialog.open();
        if (directory != null) {
            txtTarget.setText(directory);
        }
    }
}

