/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.ui.UI_Messages;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class WorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button chkEnableAutoValidation;
    private Button chkEnableAutoIdGeneration;
    private Button radioFocusModeElement;
    private Button radioFocusModePropertyDialog;
    private Button radioFocusModeEditBox;
    private Button radioAlwaysSwitchActivityType;
    private Button radioNeverSwitchActivityType;
    private Button radioWarnSwitchActivityType;
    private Button chkEnableAutoSubprocessNameGeneration;

    public WorkbenchPreferencePage() {
    }

    public WorkbenchPreferencePage(String title) {
        super(title);
    }

    public WorkbenchPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite panel = FormBuilder.createComposite((Composite)parent, (int)3);
        this.chkEnableAutoValidation = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_autoValidation, (int)3);
        this.chkEnableAutoIdGeneration = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_autoIdGeneration, (int)3);
        this.chkEnableAutoSubprocessNameGeneration = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_autoSubprocessNameGeneration, (int)3);
        Group groupSwitchFocusMode = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_SwitchFocusMode, (int)3, (int)3);
        groupSwitchFocusMode.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.radioFocusModeElement = FormBuilder.createRadioButton((Composite)groupSwitchFocusMode, (String)UI_Messages.LB_Element);
        this.radioFocusModePropertyDialog = FormBuilder.createRadioButton((Composite)groupSwitchFocusMode, (String)UI_Messages.LB_PropertyDialog);
        this.radioFocusModeEditBox = FormBuilder.createRadioButton((Composite)groupSwitchFocusMode, (String)UI_Messages.LB_EditBox);
        Group groupSwitchActivityType = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_SwitchAutomaticallyActivityType, (int)3, (int)3);
        groupSwitchActivityType.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.radioAlwaysSwitchActivityType = FormBuilder.createRadioButton((Composite)groupSwitchActivityType, (String)UI_Messages.LB_Always);
        this.radioNeverSwitchActivityType = FormBuilder.createRadioButton((Composite)groupSwitchActivityType, (String)UI_Messages.LB_Never);
        this.radioWarnSwitchActivityType = FormBuilder.createRadioButton((Composite)groupSwitchActivityType, (String)UI_Messages.LB_ShowWarning);
        this.updateCheckbox();
        this.updateSwitchActivityTypeGroup();
        this.updateFocusMode();
        return panel;
    }

    private void updateFocusMode() {
        String focusMode = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.focusMode");
        if (StringUtils.isEmpty((String)focusMode)) {
            focusMode = "focusModeElement";
        }
        this.radioFocusModeElement.setSelection(focusMode.equals("focusModeElement"));
        this.radioFocusModePropertyDialog.setSelection(focusMode.equals("focusModeDialog"));
        this.radioFocusModeEditBox.setSelection(focusMode.equals("focusModeEditor"));
    }

    private void updateSwitchActivityTypeGroup() {
        this.radioAlwaysSwitchActivityType.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType"));
        this.radioNeverSwitchActivityType.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType"));
        this.radioWarnSwitchActivityType.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType"));
    }

    private void updateCheckbox() {
        this.chkEnableAutoValidation.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoValidation"));
        this.chkEnableAutoIdGeneration.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration"));
        this.chkEnableAutoSubprocessNameGeneration.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration"));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.autoValidation", this.chkEnableAutoValidation.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration", this.chkEnableAutoIdGeneration.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration", this.chkEnableAutoSubprocessNameGeneration.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType", this.radioAlwaysSwitchActivityType.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType", this.radioNeverSwitchActivityType.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType", this.radioWarnSwitchActivityType.getSelection());
        String focusMode = "focusModeElement";
        if (this.radioFocusModeElement.getSelection()) {
            focusMode = "focusModeElement";
        } else if (this.radioFocusModePropertyDialog.getSelection()) {
            focusMode = "focusModeDialog";
        } else if (this.radioFocusModeEditBox.getSelection()) {
            focusMode = "focusModeEditor";
        }
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.focusMode", focusMode);
        return true;
    }

    protected void performDefaults() {
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.autoValidation");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.focusMode");
        this.updateCheckbox();
    }
}

