/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core;

import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.modeling.core.DoubleVerifier;
import org.eclipse.stardust.modeling.core.LongVerifier;
import org.eclipse.stardust.modeling.core.Verifier;

public class VerifierFactory {
    public static Verifier byteVerifier = new LongVerifier(0, -128L, 127L);
    public static Verifier shortVerifier = new LongVerifier(1, -32768L, 32767L);
    public static Verifier intVerifier = new LongVerifier(2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static Verifier longVerifier = new LongVerifier(3, Long.MIN_VALUE, Long.MAX_VALUE);
    public static Verifier floatVerifier = new DoubleVerifier(4, -3.4028234663852886E38, 3.4028234663852886E38);
    public static Verifier doubleVerifier = new DoubleVerifier(5, -1.7976931348623157E308, Double.MAX_VALUE);
    public static Verifier moneyVerifier = new DoubleVerifier(6, -1.7976931348623157E308, Double.MAX_VALUE);

    public static Verifier getVerifier(Type type) {
        Verifier result = null;
        if (Type.Byte.equals((Object)type)) {
            result = byteVerifier;
        } else if (Type.Short.equals((Object)type)) {
            result = shortVerifier;
        } else if (Type.Integer.equals((Object)type)) {
            result = intVerifier;
        } else if (Type.Long.equals((Object)type)) {
            result = longVerifier;
        } else if (Type.Float.equals((Object)type)) {
            result = floatVerifier;
        } else if (Type.Double.equals((Object)type)) {
            result = doubleVerifier;
        }
        return result;
    }
}

