/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.core.compare.ComparableModelElementNode;
import org.eclipse.stardust.modeling.core.compare.ModelViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ModelElementMergeViewer
extends ContentMergeViewer
implements ISelectionChangedListener {
    private static final String BUNDLE_NAME = "org.eclipse.stardust.modeling.core.compare.ModelElementMergeViewerResources";
    private TreeViewer fLeft;
    private TreeViewer fRight;
    private TreeViewer fAncestor;
    private ICompareInput cInput;

    public ModelElementMergeViewer(Composite parent, int styles, CompareConfiguration configuration, ICompareInput cInput, Viewer structureViewer) {
        super(styles, ResourceBundle.getBundle(BUNDLE_NAME), configuration);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.image_compare_view_context");
        this.buildControl(parent);
        String title = Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"subtitle2");
        this.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)title);
        this.cInput = cInput;
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.setIntrinsicViewerInput(this.fAncestor, ancestor);
        this.setIntrinsicViewerInput(this.fLeft, left);
        this.setIntrinsicViewerInput(this.fRight, right);
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    public void createControls(Composite composite) {
        this.fAncestor = new TreeViewer(composite, 0);
        this.fAncestor.setContentProvider((IContentProvider)new DiffViewerContentProvider());
        this.fAncestor.setLabelProvider((IBaseLabelProvider)new DiffViewerLabelProvider());
        this.fAncestor.setSorter((ViewerSorter)new ModelViewerSorter());
        this.fLeft = new TreeViewer(composite, 0);
        this.fLeft.setContentProvider((IContentProvider)new DiffViewerContentProvider());
        this.fLeft.setLabelProvider((IBaseLabelProvider)new DiffViewerLabelProvider());
        this.fLeft.setSorter((ViewerSorter)new ModelViewerSorter());
        this.fRight = new TreeViewer(composite, 0);
        this.fRight.setContentProvider((IContentProvider)new DiffViewerContentProvider());
        this.fRight.setLabelProvider((IBaseLabelProvider)new DiffViewerLabelProvider());
        this.fRight.setSorter((ViewerSorter)new ModelViewerSorter());
    }

    private void setIntrinsicViewerInput(TreeViewer viewer, Object input) {
        if (viewer != null) {
            viewer.setInput(input);
        }
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
    }

    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        this.fLeft.getControl().setBounds(x, y, leftWidth, height);
        this.fRight.getControl().setBounds(x + leftWidth, y, rightWidth, height);
    }

    protected void copy(boolean leftToRight) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ss;
        ISelection selection = event.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            this.setInput(ss.getFirstElement());
        }
    }

    class DiffViewerContentProvider
    implements ITreeContentProvider {
        private Object leftRoot = null;
        private Object rightRoot = null;

        DiffViewerContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != newInput) {
                this.leftRoot = null;
                this.rightRoot = null;
            }
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
        }

        public Object getParent(Object element) {
            ComparableModelElementNode parentNode = ((ComparableModelElementNode)((Object)element)).getParent();
            return parentNode;
        }

        public final boolean hasChildren(Object element) {
            return ((ComparableModelElementNode)((Object)element)).hasChildren();
        }

        public final Object[] getChildren(Object element) {
            Object[] objectArray;
            Object[] children = ((ComparableModelElementNode)((Object)element)).getChildren();
            if (children != null && children.length > 0) {
                objectArray = children;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = element;
            }
            return objectArray;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }
    }

    class DiffViewerLabelProvider
    extends LabelProvider {
        DiffViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ComparableModelElementNode) {
                return ((ComparableModelElementNode)((Object)element)).getName();
            }
            return "DEFAULT";
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof ComparableModelElementNode) {
                ComparableModelElementNode input = (ComparableModelElementNode)((Object)element);
                IDiffElement child = null;
                if (ModelElementMergeViewer.this.cInput != null && input != null) {
                    child = ((DiffNode)ModelElementMergeViewer.this.cInput).findChild(input.getName());
                }
                if (child != null) {
                    IDiffElement diffElement = child;
                    int kind = diffElement.getKind();
                    switch (kind & 0xC) {
                        case 4: {
                            kind = kind & 0xFFFFFFFB | 8;
                            break;
                        }
                        case 8: {
                            kind = kind & 0xFFFFFFF7 | 4;
                        }
                    }
                    image = ModelElementMergeViewer.this.getCompareConfiguration().getImage(input.getImage(), kind);
                } else {
                    image = input.getImage();
                }
                return image;
            }
            return null;
        }
    }
}

