/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.core.editors.AbstractGraphicalEditorPage;
import org.eclipse.stardust.modeling.core.editors.AbstractMultiPageGraphicalEditorOutlinePage;
import org.eclipse.stardust.modeling.core.editors.DelegatingZoomManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelOutlinePage;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.AlignmentSnapToGridAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CleanupModelAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CopySymbolAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateSubprocessFromSelectionAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CutAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DeleteAllAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DiagramPrintAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DistributeAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.GroupSymbolsAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.PasteSymbolAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetDefaultSizeAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShowInDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShowInOutlineAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShrinkToFitAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SnapToGridAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UngroupSymbolsAction;
import org.eclipse.stardust.modeling.core.editors.parts.properties.UndoablePropSheetEntry;
import org.eclipse.stardust.modeling.core.utils.FileEditorInputTracker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class AbstractMultiPageGraphicalEditor
extends MultiPageEditorPart
implements IAdaptable {
    private boolean isDirty = false;
    private ActionRegistry actionRegistry;
    private CommandStack sharedCommandStack;
    private EditDomain editDomain;
    private ISelectionListener selectionListener;
    private SelectionSynchronizer synchronizer;
    private DelegatingZoomManager delegatingZoomManager;
    protected KeyHandler sharedKeyHandler;
    private List<String> editorActionIDs = CollectionUtils.newList();
    private List<String> editPartActionIDs = CollectionUtils.newList();
    private List<String> stackActionIDs = CollectionUtils.newList();
    private FileEditorInputTracker editorInputTracker;
    private PropertySheetPage propertySheetPage;
    protected AbstractMultiPageGraphicalEditorOutlinePage outlinePage;

    public AbstractMultiPageGraphicalEditor() {
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
        this.editDomain.setCommandStack(this.getSharedCommandStack());
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public abstract Object getModel();

    protected abstract WorkflowModelOutlinePage createOutlinePage();

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (type == CommandStack.class) {
            return this.getSharedCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == ZoomManager.class) {
            return this.getDelegatingZoomManager();
        }
        if (type == GraphicalViewer.class) {
            return this.getCurrentPage() instanceof AbstractGraphicalEditorPage ? ((AbstractGraphicalEditorPage)this.getCurrentPage()).getGraphicalViewer() : null;
        }
        return super.getAdapter(type);
    }

    public IEditorPart getCurrentPage() {
        if (-1 == this.getActivePage()) {
            return null;
        }
        return this.getEditor(this.getActivePage());
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.updateActions(this.editorActionIDs);
    }

    protected void createActions() {
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this));
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this));
        this.addEditPartAction(new CleanupModelAction((IWorkbenchPart)this));
        this.addEditPartAction(new ShrinkToFitAction((IWorkbenchPart)this));
        this.addEditPartAction((SelectionAction)new DeleteAllAction((IWorkbenchPart)this));
        this.addEditPartAction((SelectionAction)new DirectEditAction((IWorkbenchPart)this));
        this.addEditPartAction(new AlignmentSnapToGridAction((IWorkbenchPart)this, new AlignmentAction((IWorkbenchPart)this, 1), 1));
        this.addEditPartAction(new AlignmentSnapToGridAction((IWorkbenchPart)this, new AlignmentAction((IWorkbenchPart)this, 4), 4));
        this.addEditPartAction(new AlignmentSnapToGridAction((IWorkbenchPart)this, new AlignmentAction((IWorkbenchPart)this, 8), 8));
        this.addEditPartAction(new AlignmentSnapToGridAction((IWorkbenchPart)this, new AlignmentAction((IWorkbenchPart)this, 32), 32));
        this.addEditPartAction(new AlignmentSnapToGridAction((IWorkbenchPart)this, new AlignmentAction((IWorkbenchPart)this, 2), 2));
        this.addEditPartAction(new AlignmentSnapToGridAction((IWorkbenchPart)this, new AlignmentAction((IWorkbenchPart)this, 16), 16));
        this.addEditPartAction(new DistributeAction((IWorkbenchPart)this, 64));
        this.addEditPartAction(new DistributeAction((IWorkbenchPart)this, 128));
        this.addEditPartAction(new SnapToGridAction((IWorkbenchPart)this));
        this.addEditPartAction(new SetDefaultSizeAction((IWorkbenchPart)this));
        this.addEditPartAction(new GroupSymbolsAction((IWorkbenchPart)this));
        this.addEditPartAction(new UngroupSymbolsAction((IWorkbenchPart)this));
        this.addEditorAction((EditorPartAction)new SaveAction((IEditorPart)this));
        this.addAction((IAction)new DiagramPrintAction((IWorkbenchPart)this));
        this.addEditPartAction((SelectionAction)new CutAction((IWorkbenchPart)this));
        this.addEditPartAction(new CopySymbolAction((IWorkbenchPart)this));
        this.addEditPartAction(new PasteSymbolAction((IWorkbenchPart)this));
        this.addEditPartAction((SelectionAction)new CreateSubprocessFromSelectionAction((IWorkbenchPart)this));
        this.addEditPartAction(new ShowInDiagramAction((IWorkbenchPart)this));
        this.addEditPartAction(new ShowInOutlineAction((IWorkbenchPart)this));
        ZoomInAction zoomIn = new ZoomInAction((ZoomManager)this.getDelegatingZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction((ZoomManager)this.getDelegatingZoomManager());
        this.addAction((IAction)zoomIn);
        this.addAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected CommandStack getSharedCommandStack() {
        if (this.sharedCommandStack == null) {
            this.sharedCommandStack = new CommandStack();
            this.sharedCommandStack.addCommandStackListener(new CommandStackListener(){

                public void commandStackChanged(EventObject event) {
                    AbstractMultiPageGraphicalEditor.this.setDirty(AbstractMultiPageGraphicalEditor.this.sharedCommandStack.isDirty());
                    AbstractMultiPageGraphicalEditor.this.updateActions(AbstractMultiPageGraphicalEditor.this.stackActionIDs);
                }
            });
        }
        return this.sharedCommandStack;
    }

    protected ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    AbstractMultiPageGraphicalEditor.this.updateActions(AbstractMultiPageGraphicalEditor.this.editPartActionIDs);
                }
            };
        }
        return this.selectionListener;
    }

    protected abstract boolean canDelete(ISelection var1);

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected DelegatingZoomManager getDelegatingZoomManager() {
        if (this.delegatingZoomManager == null) {
            this.delegatingZoomManager = new DelegatingZoomManager();
            if (this.getCurrentPage() instanceof AbstractGraphicalEditorPage && ((AbstractGraphicalEditorPage)this.getCurrentPage()).getGraphicalViewer() != null) {
                this.delegatingZoomManager.setCurrentZoomManager(this.getZoomManager(((AbstractGraphicalEditorPage)this.getCurrentPage()).getGraphicalViewer()));
            }
        }
        return this.delegatingZoomManager;
    }

    protected ZoomManager getZoomManager(GraphicalViewer viewer) {
        RootEditPart rootEditPart = viewer != null ? viewer.getRootEditPart() : null;
        ZoomManager zoomManager = null;
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            zoomManager = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager();
        } else if (rootEditPart instanceof ScalableRootEditPart) {
            zoomManager = ((ScalableRootEditPart)rootEditPart).getZoomManager();
        }
        return zoomManager;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addEditorAction(EditorPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActionIDs.add(action.getId());
    }

    private void updateActions(List<String> actionIds) {
        for (String id : actionIds) {
            IAction action = this.getActionRegistry().getAction((Object)id);
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected FileEditorInputTracker getEditorInputTracker() {
        if (this.editorInputTracker == null) {
            this.editorInputTracker = new FileEditorInputTracker((IEditorPart)this);
            this.editorInputTracker.addChangeVisitor(new EditorCloseTracker());
        }
        return this.editorInputTracker;
    }

    protected void closeEditor(final boolean save) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractMultiPageGraphicalEditor.this.getSite().getPage().closeEditor((IEditorPart)AbstractMultiPageGraphicalEditor.this, save);
            }
        });
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage();
            this.propertySheetPage.setRootEntry((IPropertySheetEntry)new UndoablePropSheetEntry(this.getSharedCommandStack()));
        }
        return this.propertySheetPage;
    }

    protected void setInput(IEditorInput input) {
        IFile file;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            file = ((FileEditorInput)editorInput).getFile();
            if (this.editorInputTracker != null) {
                file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getEditorInputTracker());
            }
        }
        super.setInput(input);
        editorInput = this.getEditorInput();
        if (editorInput != null) {
            if (editorInput instanceof FileEditorInput) {
                file = ((FileEditorInput)editorInput).getFile();
                file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getEditorInputTracker());
            }
            this.setPartName(editorInput.getName());
        }
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.getSelectionListener());
        this.getActionRegistry().dispose();
        super.dispose();
    }

    protected KeyHandler getSharedKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.stardust.modeling.core.forwardDelete"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'c', (int)99, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.stardust.modeling.core.connect"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'c', (int)262144, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'x', (int)262144, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.CUT.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'v', (int)262144, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId()));
        }
        return this.sharedKeyHandler;
    }

    protected AbstractMultiPageGraphicalEditorOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
        }
        return this.outlinePage;
    }

    protected void resetOutlinePage() {
        this.outlinePage = null;
    }

    public class EditorCloseTracker
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) {
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!AbstractMultiPageGraphicalEditor.this.isDirty()) {
                        AbstractMultiPageGraphicalEditor.this.closeEditor(false);
                    }
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = AbstractMultiPageGraphicalEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractMultiPageGraphicalEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }
}

