/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.IValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.IValidationStatus;
import org.eclipse.stardust.modeling.core.editors.ModelElementValidationStatus;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.IssueDelta;

public class ValidationIssueManager {
    private final ListenerList validationEventListeners = new ListenerList();
    private final Map statusRegistry = new HashMap();

    public void addValidationEventListener(IValidationEventListener listener) {
        this.validationEventListeners.add((Object)listener);
    }

    public void removeValidationEventListener(IValidationEventListener listener) {
        this.validationEventListeners.remove((Object)listener);
    }

    public void pushCurrentStatus(IValidationEventListener listener) {
        this.fireIssuesUpdated(this.statusRegistry.keySet(), new Object[]{listener});
    }

    public IValidationStatus getStatus(IModelElement element) {
        ModelElementValidationStatus status = (ModelElementValidationStatus)this.statusRegistry.get(element);
        return status != null ? status : IValidationStatus.OK;
    }

    public void resetIssues(Issue[] issues) {
        HashSet<Object> affectedElements = new HashSet<Object>();
        for (Map.Entry entry : this.statusRegistry.entrySet()) {
            ModelElementValidationStatus status = (ModelElementValidationStatus)entry.getValue();
            if (!status.hasIssues() && !status.hasChildrenWithIssues()) continue;
            affectedElements.add(entry.getKey());
        }
        this.statusRegistry.clear();
        int i = 0;
        while (i < issues.length) {
            Issue issue = issues[i];
            EObject modelElement = issue.getModelElement();
            if (modelElement != null) {
                EObject model;
                Proxy proxy;
                InvocationHandler ih;
                if (modelElement instanceof Proxy && modelElement instanceof ModelType && (ih = Proxy.getInvocationHandler(proxy = (Proxy)modelElement)) instanceof ModelUtils.EObjectInvocationHandler && (model = ((ModelUtils.EObjectInvocationHandler)ih).getModel()) instanceof ModelType) {
                    modelElement = model;
                }
                affectedElements.add(modelElement);
                ModelElementValidationStatus status = (ModelElementValidationStatus)this.statusRegistry.get(modelElement);
                if (status == null) {
                    status = new ModelElementValidationStatus();
                    this.statusRegistry.put(modelElement, status);
                }
                status.addIssue(issue);
            }
            ++i;
        }
        affectedElements.addAll(this.propagateChildStatus(affectedElements));
        this.fireIssuesUpdated(affectedElements, this.validationEventListeners.getListeners());
    }

    public void handleIssueUpdate(IssueDelta[] deltas) {
        HashSet<Object> affectedElements = new HashSet<Object>();
        int i = 0;
        while (i < deltas.length) {
            IssueDelta delta = deltas[i];
            if (delta.getTarget() instanceof EObject) {
                EObject element = (EObject)delta.getTarget();
                affectedElements.add(element);
                ModelElementValidationStatus status = (ModelElementValidationStatus)this.statusRegistry.get(element);
                if (status == null) {
                    status = new ModelElementValidationStatus();
                    this.statusRegistry.put(element, status);
                }
                List removedIssues = delta.getRemovedIssues();
                int j = 0;
                while (j < removedIssues.size()) {
                    status.removeIssue((Issue)removedIssues.get(j));
                    ++j;
                }
                List addedIssues = delta.getAddedIssues();
                int j2 = 0;
                while (j2 < addedIssues.size()) {
                    status.addIssue((Issue)addedIssues.get(j2));
                    ++j2;
                }
            }
            ++i;
        }
        affectedElements.addAll(this.propagateChildStatus(affectedElements));
        this.fireIssuesUpdated(affectedElements, this.validationEventListeners.getListeners());
    }

    private void fireIssuesUpdated(Set<?> affectedElements, Object[] listeners) {
        for (Object element : affectedElements) {
            IValidationStatus status = (ModelElementValidationStatus)this.statusRegistry.get(element);
            if (status == null) {
                status = IValidationStatus.OK;
            }
            if (!(element instanceof EObject)) continue;
            int i = 0;
            while (i < listeners.length) {
                IValidationEventListener listener = (IValidationEventListener)listeners[i];
                listener.onIssuesUpdated((EObject)element, status);
                ++i;
            }
        }
    }

    private Set<?> propagateChildStatus(Set<?> affectedElements) {
        Set updatedParents = CollectionUtils.newSet();
        for (Object target : affectedElements) {
            Object parent;
            if (!(target instanceof EObject) || !this.statusRegistry.containsKey(target)) continue;
            EObject element = (EObject)target;
            ModelElementValidationStatus elementStatus = (ModelElementValidationStatus)this.statusRegistry.get(element);
            ArrayList oldParents = new ArrayList(elementStatus.getAffectedParents());
            int j = 0;
            while (j < oldParents.size()) {
                parent = oldParents.get(j);
                updatedParents.add(parent);
                this.updateChildElementStatus(parent, element, elementStatus);
                ++j;
            }
            ModelType model = ModelUtils.findContainingModel((EObject)element);
            if (model == null || model == element) continue;
            parent = element;
            do {
                parent = parent.eContainer();
                if (elementStatus.getAffectedParents().contains(parent)) continue;
                updatedParents.add(parent);
                this.updateChildElementStatus(parent, element, elementStatus);
            } while (parent != model);
        }
        return updatedParents;
    }

    private void updateChildElementStatus(Object parent, EObject child, ModelElementValidationStatus childStatus) {
        if (parent != null) {
            ModelElementValidationStatus parentStatus = (ModelElementValidationStatus)this.statusRegistry.get(parent);
            if (parentStatus == null) {
                parentStatus = new ModelElementValidationStatus();
                this.statusRegistry.put(parent, parentStatus);
            }
            parentStatus.updateChildStatus(child, childStatus);
            if (childStatus.hasIssues()) {
                childStatus.addAffectedParent(parent);
            } else {
                childStatus.removeAffectedParent(parent);
            }
        }
    }

    public boolean hasIssues() {
        for (IValidationStatus status : this.statusRegistry.values()) {
            if (IValidationStatus.OK.equals(status)) continue;
            return true;
        }
        return false;
    }
}

