/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoutingType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.modeling.common.platform.utils.ExtensionsResolver;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.actions.EditDomainAwareAction;
import org.eclipse.stardust.modeling.core.actions.IGraphicalViewerAwareAction;
import org.eclipse.stardust.modeling.core.actions.ISpiAction;
import org.eclipse.stardust.modeling.core.editors.DiagramActionConstants;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateSubprocessAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DiagramModeAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.IActiveAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.OrientationAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ResetSubprocessAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetActivityControlFlowAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetActivityImplementationAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetActivitySubprocessAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetApplicationTypeAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetConnectionRoutingAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetDataTypeAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class WorkflowModelEditorContextMenuProvider
extends ContextMenuProvider {
    private final ActionRegistry registry;
    private final ActionRegistry localRegistry;
    private WorkflowModelEditor editor;

    WorkflowModelEditorContextMenuProvider(DiagramEditorPage pageEditor, ActionRegistry registry) {
        this((EditPartViewer)pageEditor.getGraphicalViewer(), registry, pageEditor.getWorkflowModelEditor());
        this.localRegistry.registerAction((IAction)new ToggleGridAction(pageEditor.getGraphicalViewer()));
        this.localRegistry.registerAction((IAction)new ToggleSnapToGeometryAction(pageEditor.getGraphicalViewer()));
    }

    WorkflowModelEditorContextMenuProvider(EditPartViewer viewer, ActionRegistry registry, WorkflowModelEditor editor) {
        super(viewer);
        if (editor == null) {
            try {
                this.editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        } else {
            this.editor = editor;
        }
        if (registry == null) {
            throw new IllegalArgumentException();
        }
        this.registry = registry;
        this.localRegistry = new ActionRegistry();
    }

    public IAction getAction(String id) {
        IAction action = this.localRegistry.getAction((Object)id);
        if (action == null) {
            action = this.registry.getAction((Object)id);
        }
        return action;
    }

    public void buildContextMenu(IMenuManager manager) {
        boolean isChildCategory;
        GEFActionConstants.addStandardActionGroups((IMenuManager)manager);
        IStructuredSelection selection = this.getSelection();
        IAdaptable adaptable = (IAdaptable)selection.getFirstElement();
        IModelElement modelElement = (IModelElement)adaptable.getAdapter(IModelElement.class);
        IConnectionSymbol connectionSymbol = (IConnectionSymbol)adaptable.getAdapter(IConnectionSymbol.class);
        if (!(selection.getFirstElement() instanceof TreeEditPart)) {
            modelElement = modelElement instanceof IModelElementNodeSymbol ? ((IModelElementNodeSymbol)modelElement).getModelElement() : modelElement;
        }
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.deployModel", "org.eclipse.gef.group.find");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.cleanupModelAction", "org.eclipse.gef.group.find");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.showInDiagramAction", "org.eclipse.gef.group.find");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.showInOutlineAction", "org.eclipse.gef.group.find");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.shrinkToFitAction", "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.copySymbolAction", "org.eclipse.gef.group.copy");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.pasteSymbolAction", "org.eclipse.gef.group.copy");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createSubprocessFromSelection", "org.eclipse.gef.group.copy");
        this.addActionToMenu(manager, ActionFactory.COPY.getId(), "org.eclipse.gef.group.copy");
        this.addActionToMenu(manager, ActionFactory.PASTE.getId(), "org.eclipse.gef.group.copy");
        this.addActionToMenu(manager, ActionFactory.CUT.getId(), "org.eclipse.gef.group.copy");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.connect", "org.eclipse.gef.group.print");
        if (selection.size() == 1 && !this.isObjectDescriptor(adaptable)) {
            this.addDynamicMenuEntries(modelElement, (IGraphicalObject)connectionSymbol, manager);
        }
        if (this.checkSelections(selection.toList())) {
            this.addActionToMenu(manager, ActionFactory.DELETE.getId(), Diagram_Messages.TXT_DeleteAll, "org.eclipse.gef.group.edit");
        }
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.reloadSchema", "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.deleteSymbol", "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.model.xpdl.upgradeModelDiagram", "org.eclipse.gef.group.view");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.referencesSearch", "org.eclipse.gef.group.view");
        this.addActionToMenu(manager, "org.eclipse.stardust.model.xpdl.upgradeData", "org.eclipse.gef.group.view");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createActivityGraph", "org.eclipse.gef.group.view");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createOrganizationHierarchy", "org.eclipse.gef.group.view");
        this.addActionToMenu(manager, "org.eclipse.gef.direct_edit", "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createProcessDefinition", "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createGenericActivity", "org.eclipse.gef.group.edit");
        this.addSubMenuToMenu(manager, this.createSubmenu(Diagram_Messages.LB_SUBMENU_NewActivity, DiagramActionConstants.createActivityActions), "org.eclipse.gef.group.edit");
        boolean bl = isChildCategory = selection.getFirstElement() instanceof ChildCategoryNode || adaptable instanceof EditPart && ((EditPart)adaptable).getModel() instanceof TypeDeclarationsType;
        if (isChildCategory) {
            this.addExtensionActionsToMenu(manager, Diagram_Messages.LB_EXTMENU_New, "org.eclipse.stardust.modeling.repository.common", "connections", "org.eclipse.stardust.modeling.repository.common.create.", "org.eclipse.gef.group.edit");
        }
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.repository.common.import", "org.eclipse.gef.group.print");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.repository.common.refresh", "org.eclipse.gef.group.print");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.repository.common.deleteReferences", "org.eclipse.gef.group.print");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.repository.common.addReferences", "org.eclipse.gef.group.print");
        this.addExtensionActionsToMenu(manager, Diagram_Messages.LB_EXTMENU_New, "org.eclipse.stardust.modeling.repository.common", "connectionsearch", "org.eclipse.stardust.modeling.repository.common.search", "org.eclipse.gef.group.edit");
        if (isChildCategory) {
            this.addActionsToMenu(manager, DiagramActionConstants.participantActions, "org.eclipse.gef.group.edit");
        } else {
            this.addSubMenuToMenu(manager, this.createSubmenu(Diagram_Messages.LB_SUBMENU_NewParticipant, DiagramActionConstants.participantActions), "org.eclipse.gef.group.edit");
        }
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createGenericData", "org.eclipse.gef.group.edit");
        MenuManager menu = this.createExtensionMenu(Diagram_Messages.LB_EXTMENU_NewData, "dataTypes", "org.eclipse.stardust.modeling.core.createData.");
        this.addSubMenuToMenu(manager, menu, "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createGenericApplication", "org.eclipse.gef.group.edit");
        this.addSubMenuToMenu(manager, this.createExtensionMenu(Diagram_Messages.LB_EXTMENU_NewApplication, "applicationTypes", "org.eclipse.stardust.modeling.core.createApplication."), "org.eclipse.gef.group.edit");
        this.addSubMenuToMenu(manager, this.createExtensionMenu(Diagram_Messages.LB_EXTMENU_NewInteractiveApplication, "contextTypes", "org.eclipse.stardust.modeling.core.createInteractiveApplication."), "org.eclipse.gef.group.edit");
        this.addSubMenuToMenu(manager, this.createExtensionMenu(Diagram_Messages.LB_EXTMENU_NewTrigger, "triggerTypes", "org.eclipse.stardust.modeling.core.createTrigger."), "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createLinkType", "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.createDiagram", "org.eclipse.gef.group.edit");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.convertGatewaysAction", "org.eclipse.gef.group.edit");
        this.addSubMenuToMenu(manager, this.createAlignSubmenu(), "org.eclipse.gef.group.rest");
        this.addSubMenuToMenu(manager, this.createSubmenu(Diagram_Messages.LB_SUBMENU_Distribute, DiagramActionConstants.distributeActions), "org.eclipse.gef.group.rest");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.snapToGrid", "org.eclipse.gef.group.rest");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.setDefaultSize", "org.eclipse.gef.group.rest");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.groupSymbols", "org.eclipse.gef.group.rest");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.ungroupSymbols", "org.eclipse.gef.group.rest");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.setParticipant", "org.eclipse.gef.group.view");
        this.addActionsToMenu(manager, DiagramActionConstants.viewActions, "org.eclipse.gef.group.view");
        this.addActionToMenu(manager, ActionFactory.PROPERTIES.getId(), "org.eclipse.gef.group.view");
        this.addActionToMenu(manager, "org.eclipse.stardust.modeling.core.export.diagram", "org.eclipse.gef.group.view");
        this.addContributedContextMenuActions(manager, selection);
    }

    private IStructuredSelection getSelection() {
        EditPartViewer provider = this.getViewer();
        StructuredSelection selection = provider.getSelection() instanceof IStructuredSelection ? (IStructuredSelection)provider.getSelection() : new StructuredSelection();
        return selection;
    }

    private MenuManager createAlignSubmenu() {
        MenuManager distmenu = new MenuManager(Diagram_Messages.LB_SUBMENU_Align);
        this.addActionToMenu((IMenuManager)distmenu, "org.eclipse.gef.toggle_snapto_geometry");
        this.addActionToMenu((IMenuManager)distmenu, "org.eclipse.gef.toggle_grid_visibility");
        distmenu.add((IContributionItem)new Separator());
        this.addActionsToMenu((IMenuManager)distmenu, DiagramActionConstants.horizontalAlignActions);
        distmenu.add((IContributionItem)new Separator());
        this.addActionsToMenu((IMenuManager)distmenu, DiagramActionConstants.verticalAlignAction);
        return distmenu;
    }

    private boolean checkSelections(List list) {
        for (Object next : list) {
            if (!(next instanceof ChildCategoryNode) && !(next instanceof ModelTreeEditPart) && !(next instanceof SymbolGroupEditPart) && !this.isPredefinedData(next)) continue;
            return false;
        }
        return true;
    }

    private boolean isPredefinedData(Object obj) {
        if (obj instanceof EditPart) {
            if (((EditPart)obj).getModel() instanceof DataType) {
                return ((DataType)((EditPart)obj).getModel()).isPredefined();
            }
            if (((EditPart)obj).getModel() instanceof DataSymbolType && ((DataSymbolType)((EditPart)obj).getModel()).getData() != null) {
                return ((DataSymbolType)((EditPart)obj).getModel()).getData().isPredefined();
            }
        }
        return false;
    }

    private void addActionToMenu(IMenuManager manager, String actionId, String label, String group) {
        IAction action = this.getAction(actionId);
        if (action != null && action.isEnabled()) {
            action.setText(label);
            manager.appendToGroup(group, action);
        }
    }

    private MenuManager createSubmenu(String label, String[] actionIds) {
        MenuManager distmenu = new MenuManager(label);
        int i = 0;
        while (i < actionIds.length) {
            String actionId = actionIds[i];
            this.addActionToMenu((IMenuManager)distmenu, actionId);
            ++i;
        }
        return distmenu;
    }

    private void addExtensionActionsToMenu(IMenuManager menu, String labelPrefix, String packageName, String extensionId, String actionPrefix, String group) {
        Map extensions = SpiExtensionRegistry.instance().getExtensions(packageName, extensionId);
        for (IConfigurationElement config : extensions.values()) {
            IAction action = this.getAction(String.valueOf(actionPrefix) + config.getAttribute("id"));
            if (action == null || !action.isEnabled()) continue;
            menu.appendToGroup(group, action);
        }
    }

    private MenuManager createExtensionMenu(String label, String extensionId, String prefix) {
        MenuManager menu = new MenuManager(label);
        Map extensions = SpiExtensionRegistry.instance().getExtensions(extensionId);
        for (IConfigurationElement config : extensions.values()) {
            IAction action = this.getAction(String.valueOf(prefix) + config.getAttribute("id"));
            if (action == null || !action.isEnabled()) continue;
            menu.add(action);
        }
        return menu;
    }

    private void addSubMenuToMenu(IMenuManager manager, MenuManager menu, String group) {
        if (!menu.isEmpty()) {
            manager.appendToGroup(group, (IContributionItem)menu);
        }
    }

    private void addActionsToMenu(IMenuManager manager, String[] actionIds) {
        int i = 0;
        while (i < actionIds.length) {
            String actionId = actionIds[i];
            this.addActionToMenu(manager, actionId);
            ++i;
        }
    }

    private void addActionsToMenu(IMenuManager manager, String[] actionIds, String group) {
        int i = 0;
        while (i < actionIds.length) {
            String actionId = actionIds[i];
            this.addActionToMenu(manager, actionId, group);
            ++i;
        }
    }

    private void addActionToMenu(IMenuManager manager, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null && action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addActionToMenu(IMenuManager manager, String actionId, String group) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            if (action instanceof IActiveAction) {
                IActiveAction activeAction = (IActiveAction)action;
                if (activeAction.isActive()) {
                    manager.appendToGroup(group, action);
                }
            } else if (action.isEnabled()) {
                manager.appendToGroup(group, action);
            }
        }
    }

    private void addDynamicMenuEntries(IModelElement actualElement, IGraphicalObject elementSymbol, IMenuManager manager) {
        if (actualElement instanceof ActivityType) {
            this.addActivityMenuEntries((ActivityType)actualElement, manager);
        }
        if (elementSymbol instanceof IConnectionSymbol) {
            this.addConnectionMenuEntries((IConnectionSymbol)elementSymbol, manager);
        } else if (actualElement instanceof IConnectionSymbol) {
            this.addConnectionMenuEntries((IConnectionSymbol)actualElement, manager);
        }
        if (actualElement instanceof DataType) {
            this.addDataMenuEntries((DataType)actualElement, manager);
        }
        if (actualElement instanceof ApplicationType) {
            this.addApplicationMenuEntries((ApplicationType)actualElement, manager);
        }
        if (actualElement instanceof DiagramType) {
            this.addDiagramMenuEntries((DiagramType)actualElement, manager);
        }
    }

    private void addDiagramMenuEntries(DiagramType diagram, IMenuManager manager) {
        EObject object;
        int size;
        EditDomain domain = this.getViewer().getEditDomain();
        if (ModelUtils.findContainingProcess((EObject)diagram) != null && DiagramUtil.getDefaultPool((DiagramType)diagram) != null && !PoolLaneUtils.containsLanes(this.editor.findEditPart(diagram))) {
            MenuManager classic = new MenuManager(Diagram_Messages.WorkflowModelEditorContextMenuProvider_DIAGRAM_MODE);
            DiagramModeAction[] actions = new DiagramModeAction[]{new DiagramModeAction(Diagram_Messages.DIAGRAM_MODE_ON, diagram, domain, true), new DiagramModeAction(Diagram_Messages.DIAGRAM_MODE_OFF, diagram, domain, false)};
            int i = 0;
            while (i < actions.length) {
                DiagramModeAction action = actions[i];
                if (action.getDiagramMode().equals((Object)diagram.getMode())) {
                    action.setChecked(true);
                }
                classic.add((IAction)action);
                ++i;
            }
            manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)classic);
        }
        if ((size = diagram.eContents().size()) > 1) {
            return;
        }
        if (size == 1 && (object = (EObject)diagram.eContents().get(0)) instanceof PoolSymbol) {
            if (!DiagramUtil.isDefaultPool((ISwimlaneSymbol)((ISwimlaneSymbol)object))) {
                return;
            }
            if (object.eContents().size() != 0) {
                return;
            }
        }
        if (DiagramUtil.getDefaultPool((DiagramType)diagram) != null) {
            MenuManager orientation = new MenuManager(Diagram_Messages.WorkflowModelEditorContextMenuProvider_ORIENTATION);
            OrientationAction[] orientationActions = new OrientationAction[]{new OrientationAction(OrientationType.VERTICAL_LITERAL, diagram, domain), new OrientationAction(OrientationType.HORIZONTAL_LITERAL, diagram, domain)};
            int i = 0;
            while (i < orientationActions.length) {
                OrientationAction action = orientationActions[i];
                if (action.getOrientationType().equals((Object)diagram.getOrientation())) {
                    action.setChecked(true);
                }
                orientation.add((IAction)action);
                ++i;
            }
            manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)orientation);
        }
    }

    private void addApplicationMenuEntries(ApplicationType application, IMenuManager manager) {
        if (!application.isInteractive()) {
            ModelType model = (ModelType)application.eContainer();
            EList modelApplicationTypes = model.getApplicationType();
            String[] missingApplicationTypes = this.getMissingApplicationTypes((List)modelApplicationTypes);
            if (missingApplicationTypes.length > 0) {
                this.addMetaTypes(model, missingApplicationTypes, "applicationTypes", CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType_Synchronous()});
            }
            EList applicationTypes = model.getApplicationType();
            EditDomain domain = this.getViewer().getEditDomain();
            MenuManager implementation = new MenuManager(Diagram_Messages.WorkflowModelEditorContextMenuProvider_TXT_MENU_MANAGER_SetType);
            SetApplicationTypeAction[] actions = new SetApplicationTypeAction[applicationTypes.size()];
            int i = 0;
            while (i < actions.length) {
                actions[i] = new SetApplicationTypeAction((ApplicationTypeType)applicationTypes.get(i), application, domain);
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                SetApplicationTypeAction action = actions[i];
                if (action.getType().equals(application.getType())) {
                    action.setChecked(true);
                }
                implementation.add((IAction)action);
                ++i;
            }
            manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)implementation);
        }
    }

    private boolean isObjectDescriptor(IAdaptable adaptable) {
        return adaptable.getAdapter(IObjectDescriptor.class) != null;
    }

    private void addDataMenuEntries(DataType data, IMenuManager manager) {
        if (!data.isPredefined()) {
            ModelType model = (ModelType)data.eContainer();
            EList dataTypes = model.getDataType();
            EditDomain domain = this.getViewer().getEditDomain();
            MenuManager implementation = new MenuManager(Diagram_Messages.WorkflowModelEditorContextMenuProvider_TXT_MENU_MANAGER_SetType);
            SetDataTypeAction[] actions = new SetDataTypeAction[dataTypes.size()];
            int i = 0;
            while (i < actions.length) {
                actions[i] = new SetDataTypeAction((DataTypeType)dataTypes.get(i), data, domain);
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                SetDataTypeAction action = actions[i];
                if (action.getType().equals(data.getType())) {
                    action.setChecked(true);
                }
                implementation.add((IAction)action);
                ++i;
            }
            manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)implementation);
        }
    }

    private void addActivityMenuEntries(ActivityType activity, IMenuManager manager) {
        this.addActivityControlFlowMenuEntries(activity, manager);
        this.addActivityImplementationMenuEntries(activity, manager);
        this.addActivitySubprocessMenuEntries(activity, manager);
    }

    private void addActivitySubprocessMenuEntries(ActivityType activity, IMenuManager manager) {
        if (ActivityImplementationType.SUBPROCESS_LITERAL == activity.getImplementation()) {
            MenuManager subprocess = new MenuManager(Diagram_Messages.WorkflowModelEditorContextMenuProvider_TXT_MENU_MANAGER_Subprocess);
            ResetSubprocessAction resetSubprocessAction = (ResetSubprocessAction)this.getAction("org.eclipse.stardust.modeling.core.resetSubprocessDefinition");
            resetSubprocessAction.setActivity(activity);
            if (resetSubprocessAction.isEnabled()) {
                subprocess.add((IAction)resetSubprocessAction);
                subprocess.add((IContributionItem)new Separator());
            }
            ModelType model = ModelUtils.findContainingModel((EObject)activity);
            ProcessDefinitionType implementationProcess = activity.getImplementationProcess();
            for (ProcessDefinitionType process : model.getProcessDefinition()) {
                if (process == activity.eContainer()) continue;
                SetActivitySubprocessAction action = new SetActivitySubprocessAction(activity, process, this.editor);
                if (process == implementationProcess) {
                    action.setChecked(true);
                }
                subprocess.add((IAction)action);
            }
            CreateSubprocessAction subprocessAction = (CreateSubprocessAction)this.getAction("org.eclipse.stardust.modeling.core.createSubprocessDefinition");
            subprocessAction.setActivity(activity);
            subprocess.add((IAction)subprocessAction);
            manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)subprocess);
        }
    }

    private void addActivityImplementationMenuEntries(ActivityType activity, IMenuManager manager) {
        MenuManager implementationMenu = new MenuManager(Diagram_Messages.TXT_MENU_MANAGER_Implementation);
        EditDomain domain = this.getViewer().getEditDomain();
        ActivityImplementationType type = activity.getImplementation();
        ActivityImplementationType[] activityImplementationTypeArray = ActivityImplementationType.values();
        int n = activityImplementationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityImplementationType value = activityImplementationTypeArray[n2];
            SetActivityImplementationAction action = new SetActivityImplementationAction(value, activity, domain);
            if (value == type) {
                action.setChecked(true);
            }
            implementationMenu.add((IAction)action);
            ++n2;
        }
        manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)implementationMenu);
    }

    private void addActivityControlFlowMenuEntries(ActivityType activity, IMenuManager manager) {
        FlowControlType[] flowControlTypeArray = FlowControlType.values();
        int n = flowControlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlowControlType flow = flowControlTypeArray[n2];
            if (flow != FlowControlType.NONE_LITERAL) {
                manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)this.createJoinSplitMenu(flow, activity));
            }
            ++n2;
        }
    }

    private MenuManager createJoinSplitMenu(FlowControlType flow, ActivityType activity) {
        String title;
        switch (flow) {
            case JOIN_LITERAL: {
                title = Diagram_Messages.TXT_MENU_MANAGER_JoinBehavior;
                break;
            }
            case SPLIT_LITERAL: {
                title = Diagram_Messages.TXT_MENU_MANAGER_SplitBehavior;
                break;
            }
            default: {
                title = "";
            }
        }
        MenuManager joinSplitMenu = new MenuManager(title);
        if (flow == FlowControlType.JOIN_LITERAL && !ActivityUtil.hasStartEvent((ActivityType)activity) || flow == FlowControlType.SPLIT_LITERAL && !ActivityUtil.hasEndEvent((ActivityType)activity)) {
            EditDomain domain = this.getViewer().getEditDomain();
            JoinSplitType type = flow == FlowControlType.JOIN_LITERAL ? activity.getJoin() : activity.getSplit();
            JoinSplitType[] joinSplitTypeArray = JoinSplitType.values();
            int n = joinSplitTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JoinSplitType value = joinSplitTypeArray[n2];
                SetActivityControlFlowAction action = new SetActivityControlFlowAction(this.editor, domain, activity, flow, value);
                if (value == type) {
                    action.setChecked(true);
                }
                joinSplitMenu.add((IAction)action);
                ++n2;
            }
        }
        return joinSplitMenu;
    }

    private void addConnectionMenuEntries(IConnectionSymbol connection, IMenuManager manager) {
        EditDomain domain = this.getViewer().getEditDomain();
        MenuManager implementation = new MenuManager(Diagram_Messages.WorkflowModelEditorContextMenuProvider_Routing);
        SetConnectionRoutingAction[] actions = new SetConnectionRoutingAction[]{new SetConnectionRoutingAction(RoutingType.DEFAULT_LITERAL, connection, domain), new SetConnectionRoutingAction(RoutingType.SHORTEST_PATH_LITERAL, connection, domain), new SetConnectionRoutingAction(RoutingType.MANHATTAN_LITERAL, connection, domain), new SetConnectionRoutingAction(RoutingType.EXPLICIT_LITERAL, connection, domain)};
        int i = 0;
        while (i < actions.length) {
            SetConnectionRoutingAction action = actions[i];
            if (action.getImplType().equals((Object)connection.getRouting())) {
                action.setChecked(true);
            }
            implementation.add((IAction)action);
            ++i;
        }
        manager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)implementation);
    }

    private void addContributedContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        ModelType model = null;
        List<IModelElement> selectedElements = Collections.emptyList();
        List<IGraphicalObject> selectedSymbols = Collections.emptyList();
        List selectedObjects = Collections.emptyList();
        if (!selection.isEmpty()) {
            selectedElements = CollectionUtils.newList();
            selectedSymbols = CollectionUtils.newList();
            selectedObjects = CollectionUtils.newList();
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                IModelElement selectedElement = null;
                IGraphicalObject selectedSymbol = null;
                Object item = i.next();
                if (item instanceof IAdaptable) {
                    IModelElement me = (IModelElement)((IAdaptable)item).getAdapter(IModelElement.class);
                    if (me instanceof IGraphicalObject) {
                        selectedSymbol = (IGraphicalObject)me;
                    } else {
                        selectedElement = me;
                    }
                    if (me != null) {
                        model = ModelUtils.findContainingModel((EObject)me);
                    } else {
                        EObject eobject = (EObject)((IAdaptable)item).getAdapter(EObject.class);
                        if (eobject != null) {
                            selectedObjects.add(eobject);
                        }
                    }
                }
                if (selectedSymbol != null) {
                    selectedSymbols.add(selectedSymbol);
                    if (selectedSymbol instanceof IModelElementNodeSymbol) {
                        selectedElement = ((IModelElementNodeSymbol)selectedSymbol).getModelElement();
                    } else if (selectedSymbol instanceof IConnectionSymbol && selectedSymbol instanceof TransitionConnectionType) {
                        selectedElement = ((TransitionConnectionType)selectedSymbol).getTransition();
                    }
                }
                if (selectedElement == null) continue;
                selectedElements.add(selectedElement);
            }
            selectedElements = Collections.unmodifiableList(selectedElements);
            selectedSymbols = Collections.unmodifiableList(selectedSymbols);
            selectedObjects = Collections.unmodifiableList(selectedObjects);
        }
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.stardust.modeling.core.contextMenuAction");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement extension = elements[i];
            try {
                Object actionImpl;
                boolean matchesType;
                boolean bl = matchesType = this.isTypeMatching(selectedElements, extension, "targetElementType") && this.isTypeMatching(selectedSymbols, extension, "targetSymbolType") && this.isTypeMatching(selectedObjects, extension, "targetEObjectType");
                if (matchesType && (actionImpl = extension.createExecutableExtension("actionClass")) instanceof IAction) {
                    IAction action = (IAction)actionImpl;
                    if (actionImpl instanceof EditDomainAwareAction) {
                        ((EditDomainAwareAction)action).setContext(this.getViewer().getEditDomain(), model, selectedElements, selectedSymbols);
                        ((EditDomainAwareAction)action).setEditor(this.editor);
                    }
                    if (actionImpl instanceof IGraphicalViewerAwareAction && this.getViewer() instanceof GraphicalViewer) {
                        ((IGraphicalViewerAwareAction)actionImpl).setGraphicalViewer((IWorkbenchPart)this.editor, (GraphicalViewer)this.getViewer());
                    }
                    if (actionImpl instanceof ISpiAction) {
                        ((ISpiAction)actionImpl).setConfiguration(extension, this.editor, selection);
                    }
                    if (action.isEnabled()) {
                        String groupName = "org.eclipse.gef.group.rest";
                        String groupId = extension.getAttribute("group");
                        if (!StringUtils.isEmpty((String)groupId)) {
                            IContributionItem[] menuItems = manager.getItems();
                            int j = 0;
                            while (j < menuItems.length) {
                                IContributionItem menuItem = menuItems[j];
                                if (menuItem.isGroupMarker() && menuItem.getId().endsWith(groupId)) {
                                    groupName = menuItem.getId();
                                    break;
                                }
                                ++j;
                            }
                        }
                        manager.appendToGroup(groupName, action);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    private boolean isTypeMatching(List searchList, IConfigurationElement extension, String attributeName) throws ClassNotFoundException {
        boolean matches;
        String typeName = extension.getAttribute(attributeName);
        if (!StringUtils.isEmpty((String)typeName)) {
            matches = !searchList.isEmpty();
            Iterator i = searchList.iterator();
            while (i.hasNext()) {
                matches &= ExtensionsResolver.isMatchingClass(i.next(), (String)attributeName, (IConfigurationElement)extension);
            }
        } else {
            matches = true;
        }
        return matches;
    }

    private String[] getMissingApplicationTypes(List modelApplicationTypes) {
        Map applicationTypesExtensions = SpiExtensionRegistry.instance().getExtensions("applicationTypes");
        ArrayList<String> result = new ArrayList<String>();
        new ArrayList();
        for (IConfigurationElement config : applicationTypesExtensions.values()) {
            boolean found = false;
            for (ApplicationTypeType modelApplicationType : modelApplicationTypes) {
                if (!modelApplicationType.getId().equals(config.getAttribute("id"))) continue;
                found = true;
            }
            if (found) continue;
            result.add(config.getAttribute("id"));
        }
        String[] str = result.toArray(new String[result.size()]);
        return str;
    }

    private void addMetaTypes(ModelType model, String[] ids, String extensionPointId, EClass type, EStructuralFeature[] features) {
        Map extensions = SpiExtensionRegistry.instance().getExtensions(extensionPointId);
        int i = 0;
        while (i < ids.length) {
            IConfigurationElement config = (IConfigurationElement)extensions.get(ids[i]);
            CreateMetaTypeCommand command = new CreateMetaTypeCommand(config, type, features);
            command.setParent((EObject)model);
            command.execute();
            ++i;
        }
    }
}

