/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.dnd;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.DiagramPlugin;

public abstract class IGatewayLocator {
    public abstract Dimension getGatewayLocation(FlowControlType var1, Dimension var2, int var3);

    public static IGatewayLocator getDefaultLocator(final INodeSymbol symbol) {
        return new IGatewayLocator(){

            @Override
            public Dimension getGatewayLocation(FlowControlType gatewayKind, Dimension activitySize, int gatewaySize) {
                int width = (activitySize.width - gatewaySize) / 2;
                int height = 0;
                if (DiagramPlugin.isVerticalModelling((IGraphicalObject)symbol)) {
                    if (FlowControlType.JOIN_LITERAL.equals((Object)gatewayKind)) {
                        height = -(activitySize.height + 3 * gatewaySize) / 2;
                    } else if (FlowControlType.SPLIT_LITERAL.equals((Object)gatewayKind)) {
                        height = (activitySize.height + 3 * gatewaySize) / 2;
                    }
                } else if (FlowControlType.JOIN_LITERAL.equals((Object)gatewayKind)) {
                    width -= (activitySize.width + 2 * gatewaySize) / 2;
                } else if (FlowControlType.SPLIT_LITERAL.equals((Object)gatewayKind)) {
                    width += (activitySize.width + 3 * gatewaySize) / 2;
                }
                return new Dimension(width, height);
            }
        };
    }
}

