/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.stardust.modeling.core.editors.figures.IGraphicalObjectFigure;
import org.eclipse.stardust.modeling.core.editors.figures.routers.DiagramShortestPathConnectionRouter;
import org.eclipse.stardust.modeling.core.editors.figures.routers.TransitionConnectionRouter;
import org.eclipse.swt.graphics.Color;

public class AbstractConnectionSymbolFigure
extends PolylineConnection
implements IGraphicalObjectFigure {
    public static final int ROUTING_DEFAULT = 0;
    public static final int ROUTING_SHORTEST_PATH = -1;
    public static final int ROUTING_MANHATTAN = -2;
    public static final int ROUTING_EXPLICIT = -3;
    private Color defaultBorderColor = ColorConstants.black;
    private Color defaultFillColor = ColorConstants.black;
    private int defaultRouting;
    private int routing = this.defaultRouting = -1;

    public AbstractConnectionSymbolFigure() {
        this.setSourceDecoration(null);
        this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
    }

    public void setDefaultBorderColor(Color color) {
        this.defaultBorderColor = color != null ? color : ColorConstants.black;
        this.setForegroundColor(null);
    }

    public void setDefaultFillColor(Color color) {
        this.defaultFillColor = color != null ? color : ColorConstants.black;
        this.setFillColor(null);
    }

    public void setDefaultRouting(int routing) {
        switch (routing) {
            case -2: {
                this.defaultRouting = -2;
                break;
            }
            case -3: {
                this.defaultRouting = -3;
                break;
            }
            default: {
                this.defaultRouting = -1;
            }
        }
        this.setRouting(this.defaultRouting);
    }

    @Override
    public void setBorderColor(Color color) {
        this.setForegroundColor(color != null ? color : this.defaultBorderColor);
    }

    @Override
    public void setFillColor(Color color) {
        this.setBackgroundColor(color != null ? color : this.defaultFillColor);
    }

    public int getRouting() {
        return this.routing;
    }

    public void setRouting(int routing) {
        switch (routing) {
            case -1: {
                this.routing = -1;
                break;
            }
            case -2: {
                this.routing = -2;
                break;
            }
            case -3: {
                this.routing = -3;
                break;
            }
            default: {
                this.routing = this.defaultRouting;
            }
        }
        this.setConnectionRouter();
    }

    public void setConnectionRouter(ConnectionRouter cr) {
    }

    public void setConnectionRouter() {
        ConnectionRouter cr = ConnectionRouter.NULL;
        ConnectionRouter router = this.getConnectionRouter();
        ConnectionRouter newRouter = cr;
        if (cr != null) {
            switch (this.routing) {
                case -1: {
                    if (cr instanceof DiagramShortestPathConnectionRouter) {
                        newRouter = cr;
                        break;
                    }
                    if (!(this.getParent() instanceof ConnectionLayer) || !(((ConnectionLayer)this.getParent()).getConnectionRouter() instanceof DiagramShortestPathConnectionRouter)) break;
                    newRouter = ((ConnectionLayer)this.getParent()).getConnectionRouter();
                    break;
                }
                case -2: {
                    newRouter = router instanceof TransitionConnectionRouter ? router : new TransitionConnectionRouter();
                    break;
                }
                case -3: {
                    newRouter = router instanceof BendpointConnectionRouter ? router : new BendpointConnectionRouter();
                    break;
                }
            }
        }
        super.setConnectionRouter(newRouter);
    }

    public void revalidate() {
        this.invalidate();
        if (this.getParent() == null || this.isValidationRoot()) {
            this.getUpdateManager().addInvalidFigure((IFigure)this);
        } else {
            this.getParent().revalidate();
        }
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.getConnectionRouter().invalidate((Connection)this);
        }
    }
}

