/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stardust.modeling.core.editors.figures.EditableFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IGraphicalObjectFigure;
import org.eclipse.stardust.modeling.core.editors.figures.ILabeledFigure;
import org.eclipse.stardust.modeling.core.editors.figures.MyBorderLayout;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractLabeledFigure
extends RoundedRectangle
implements IGraphicalObjectFigure,
ILabeledFigure,
EditableFigure {
    private final Label label;
    private Figure shape;
    private final Color defaultBorderColor;
    private final Color defaultFillColor;

    public AbstractLabeledFigure(Figure shape) {
        this(shape, ColorConstants.darkGray, ColorConstants.white);
    }

    public AbstractLabeledFigure(Figure shape, Color borderColor, Color fillColor) {
        this.defaultBorderColor = borderColor;
        this.defaultFillColor = fillColor;
        this.setCornerDimensions(new Dimension(12, 12));
        this.setFill(false);
        this.setBorder((Border)new MarginBorder(1));
        this.label = this.createLabel();
        this.label.setBorder((Border)new MarginBorder(1, 6, 1, 6));
        this.label.setForegroundColor(ColorConstants.black);
        this.label.setOpaque(true);
        this.shape = shape;
        this.setLayoutManager(this.createFigureLayout());
        this.doAddShape(shape);
        this.doAddLabel(this.label);
        this.setBorderColor(null);
        this.setFillColor(null);
        this.setMinimumSize(new Dimension(50, -1));
        this.setMaximumSize(new Dimension(300, 100));
    }

    protected Label createLabel() {
        return new Label();
    }

    protected LayoutManager createFigureLayout() {
        return new MyBorderLayout();
    }

    protected void doAddShape(Figure shape) {
        this.add((IFigure)shape, MyBorderLayout.CENTER);
    }

    protected void doRemoveShape(Figure shape) {
        this.remove((IFigure)shape);
    }

    protected void doAddLabel(Label label) {
        this.add((IFigure)label, MyBorderLayout.BOTTOM);
    }

    protected void doRemoveLabel(Label label) {
        this.remove((IFigure)label);
    }

    @Override
    public void setBorderColor(Color color) {
        this.setForegroundColor(color != null ? color : this.defaultBorderColor);
    }

    @Override
    public void setFillColor(Color color) {
        this.setBackgroundColor(color != null ? color : this.defaultFillColor);
    }

    protected Label getLabel() {
        return this.label;
    }

    @Override
    public void setName(String name) {
        this.label.setText(name != null ? name : "");
    }

    public void setShape(Figure figure) {
        if (this.shape != figure) {
            this.doRemoveShape(this.shape);
            this.shape = figure;
            this.doAddShape(this.shape);
        }
    }

    public Figure getShape() {
        return this.shape;
    }

    @Override
    public void setText(String text) {
        this.getLabel().setText(text == null ? "" : text);
    }

    @Override
    public String getText() {
        return this.getLabel().getText();
    }

    @Override
    public Rectangle getEditingBounds() {
        return this.getLabel().getBounds();
    }

    @Override
    public int getEditingStyle() {
        return 4;
    }

    protected Color getDefaultBorderColor() {
        return this.defaultBorderColor;
    }

    protected Color getDefaultFillColor() {
        return this.defaultFillColor;
    }
}

