/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractCompartmentFigure;
import org.eclipse.stardust.modeling.core.editors.figures.DiagramLayer;
import org.eclipse.stardust.modeling.core.editors.figures.IIdentifiableElementFigure;
import org.eclipse.stardust.modeling.core.editors.figures.SwimlaneBorder;
import org.eclipse.stardust.modeling.core.editors.figures.SymbolContainerLayout;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;

public abstract class AbstractSwimlaneFigure
extends AbstractCompartmentFigure
implements IIdentifiableElementFigure {
    private String name;

    public AbstractSwimlaneFigure(AbstractSwimlaneEditPart part) {
        super((GraphicalEditPart)part);
        this.setLayoutManager((LayoutManager)new SymbolContainerLayout());
        this.setOpaque(false);
        this.setBorder((Border)new SwimlaneBorder((IIdentifiableElement)part.getSwimlaneModel()));
    }

    public Insets getAbstractSwimlaneFigureInsets() {
        CompoundBorder border = (CompoundBorder)this.getBorder();
        SwimlaneBorder outerBorder = (SwimlaneBorder)border.getOuterBorder();
        MarginBorder innerBorder = (MarginBorder)border.getInnerBorder();
        Insets insets = outerBorder.getSwimlaneBorderInsets();
        insets.add(innerBorder.getInsets(null));
        return insets;
    }

    public AbstractSwimlaneEditPart getSwimlaneEditPart() {
        return (AbstractSwimlaneEditPart)this.getEditPart();
    }

    @Override
    public void setId(String id) {
    }

    public void setName(String name) {
        this.name = name;
        this.refresh();
    }

    public void refresh() {
        SwimlaneBorder swimlaneBorder = this.getSwimlaneBorder();
        if (swimlaneBorder != null) {
            AbstractSwimlaneEditPart part = (AbstractSwimlaneEditPart)this.getEditPart();
            IModelParticipant participant = part.getSwimlaneModel().getParticipantReference();
            swimlaneBorder.setLabel(participant == null ? this.fixName() : String.valueOf(this.fixName()) + " (" + (participant.getName() == null || participant.getName().length() == 0 ? (participant.getId() == null ? "?" : participant.getId()) : participant.getName()) + ")");
            if (participant != null) {
                swimlaneBorder.setHasParticipant(true);
            } else {
                swimlaneBorder.setHasParticipant(false);
            }
            this.repaint();
        }
    }

    private SwimlaneBorder getSwimlaneBorder() {
        Border border = this.getBorder();
        if (border instanceof CompoundBorder) {
            border = ((CompoundBorder)border).getOuterBorder();
        }
        return border instanceof SwimlaneBorder ? (SwimlaneBorder)border : null;
    }

    private String fixName() {
        return this.name == null ? "" : this.name;
    }

    public void setOrientation(int orientation) {
        SwimlaneBorder swimlaneBorder = this.getSwimlaneBorder();
        if (swimlaneBorder != null) {
            swimlaneBorder.setOrientation(orientation);
            this.repaint();
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension prefSize = super.getPreferredSize(-1, -1);
        prefSize.union(this.getMinimumSize());
        IFigure parent = this.getParent();
        if (parent instanceof DiagramLayer) {
            Rectangle bounds = null;
            if (this.getEditPart() instanceof ScalableRootEditPart) {
                ScalableRootEditPart root = (ScalableRootEditPart)this.getEditPart().getRoot();
                bounds = root.getFigure().getClientArea();
            } else if (this.getEditPart() instanceof ScalableFreeformRootEditPart) {
                ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)this.getEditPart().getRoot();
                bounds = root.getFigure().getClientArea();
            } else {
                AbstractGraphicalEditPart root = (AbstractGraphicalEditPart)this.getEditPart().getRoot();
                bounds = root.getFigure().getClientArea();
            }
            if (this.isVerticalModelling()) {
                prefSize.height = Math.max(prefSize.height, bounds.height);
            } else {
                prefSize.width = Math.max(prefSize.width, bounds.width);
            }
        }
        return prefSize;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

