/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractLabeledFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IIconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IconFigure;

public class DataSymbolFigure
extends AbstractLabeledFigure
implements IIconFigure {
    public DataSymbolFigure(String icon) {
        super(new DataPictogram(icon));
        this.setOutline(false);
    }

    @Override
    public void setIconPath(String iconPath) {
        ((IIconFigure)this.getShape()).setIconPath(iconPath);
    }

    private static class DataPictogram
    extends Figure
    implements IIconFigure {
        private Dimension cornerDimension = new Dimension(8, 8);
        private IconFigure icon;

        public DataPictogram(String iconPath) {
            this.icon = new IconFigure(iconPath);
            this.setLayoutManager((LayoutManager)new DataPictogramLayout());
            this.add((IFigure)this.icon);
        }

        @Override
        public void setIconPath(String iconPath) {
            this.icon.setIconPath(iconPath);
        }

        public Dimension getMinimumSize(int wHint, int hHint) {
            Dimension iconSize = this.icon.getMinimumSize(wHint, hHint);
            Dimension szPictogram = iconSize.getExpanded(0, iconSize.height);
            szPictogram.expand(10, 10);
            return szPictogram;
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds();
            int lineWidth = 1;
            graphics.pushState();
            try {
                int[] p = new int[]{bounds.x + bounds.width - this.cornerDimension.width, bounds.y, bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - lineWidth, bounds.x + bounds.width - lineWidth, bounds.y + bounds.height - lineWidth, bounds.x + bounds.width - lineWidth, bounds.y + this.cornerDimension.height};
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.fillPolygon(p);
                p = new int[]{bounds.x + bounds.width - lineWidth - this.cornerDimension.width, bounds.y, bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - lineWidth, bounds.x + bounds.width - lineWidth, bounds.y + bounds.height - lineWidth, bounds.x + bounds.width - lineWidth, bounds.y + this.cornerDimension.height, bounds.x + bounds.width - lineWidth - this.cornerDimension.width, bounds.y + this.cornerDimension.height, bounds.x + bounds.width - lineWidth - this.cornerDimension.width, bounds.y, bounds.x + bounds.width - lineWidth, bounds.y + this.cornerDimension.height};
                graphics.setForegroundColor(ColorConstants.lightGray);
                graphics.drawPolyline(p);
            }
            finally {
                graphics.popState();
            }
        }

        private class DataPictogramLayout
        extends AbstractLayout {
            private DataPictogramLayout() {
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                if (container instanceof DataPictogram) {
                    DataPictogram dp = (DataPictogram)container;
                    Dimension iconSize = dp.icon.getMinimumSize(wHint, hHint);
                    Dimension szPictogram = iconSize.getExpanded(0, iconSize.height);
                    szPictogram.expand(10, 10);
                    return szPictogram;
                }
                return null;
            }

            public void layout(IFigure container) {
                if (container instanceof DataPictogram) {
                    DataPictogram dp = (DataPictogram)container;
                    Rectangle rectIcon = dp.getBounds().getCopy();
                    rectIcon.y += ((DataPictogram)dp).cornerDimension.height;
                    rectIcon.shrink(2, 2);
                    Dimension szIcon = dp.icon.getPreferredSize();
                    rectIcon.shrink((rectIcon.width - szIcon.width) / 2, (rectIcon.height - szIcon.height) / 2);
                    dp.icon.setBounds(rectIcon);
                }
            }
        }
    }
}

