/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class LaneCompartmentLayout
extends FlowLayout {
    public LaneCompartmentLayout() {
        this.setHorizontal(true);
        this.setMinorSpacing(3);
    }

    public void layout(IFigure parent) {
        Rectangle bounds = parent.getClientArea();
        for (IFigure child : parent.getChildren()) {
            Dimension r = null;
            if (child instanceof FreeformFigure) continue;
            r = child.getPreferredSize();
            bounds.width = r.width;
            child.setBounds(bounds);
            bounds.x += r.width + this.getMinorSpacing();
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension extent = null;
        for (IFigure child : container.getChildren()) {
            Dimension childSize = null;
            if (!(child instanceof FreeformFigure)) {
                childSize = child.getPreferredSize();
            }
            if (childSize == null) continue;
            if (extent == null) {
                extent = childSize.getCopy();
                continue;
            }
            extent.width += childSize.width + this.getMinorSpacing();
            extent.height = Math.max(extent.height, childSize.height);
        }
        if (extent != null) {
            extent.union(container.getMinimumSize());
        } else {
            extent = container.getMinimumSize();
        }
        Insets insets = container.getInsets();
        if (extent == null) {
            extent = new Dimension(insets.getWidth(), insets.getHeight());
        } else {
            extent.expand(insets.getWidth(), insets.getHeight());
        }
        return extent;
    }
}

