/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.figures.LaneFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class SwimlaneBorder
extends CompoundBorder {
    public static int ButtonSize = 20;
    public static final int ORIENTATION_VERTICAL = -1;
    public static final int ORIENTATION_HORIZONTAL = -2;
    public static final int borderWidth = 2;
    public static Color defaultSwimlaneBorderColor = new Color(null, 225, 225, 225);
    public static Color participantSwimlaneBorderColor = ColorConstants.lightGray;

    public SwimlaneBorder(IIdentifiableElement identifiable) {
        this(identifiable, null);
    }

    public SwimlaneBorder(IIdentifiableElement identifiable, IFigure button) {
        super((Border)new LineBorder(defaultSwimlaneBorderColor, 2), (Border)new BorderWithLabel(identifiable.getName(), button));
        this.setOrientation(DiagramPlugin.isVerticalModelling((IGraphicalObject)identifiable) ? -1 : -2);
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)identifiable));
        this.setDiagramMode(diagram.getMode());
    }

    public void setLabel(String label) {
        ((BorderWithLabel)this.getInnerBorder()).setLabel(label);
    }

    public Insets getSwimlaneBorderInsets() {
        BorderWithLabel innerBorder = (BorderWithLabel)this.getInnerBorder();
        LineBorder outerBorder = (LineBorder)this.getOuterBorder();
        Insets insets = null;
        if (innerBorder.insets == null) {
            insets = new Insets(outerBorder.getInsets(null));
        } else {
            insets = new Insets(innerBorder.insets);
            insets.add(outerBorder.getInsets(null));
        }
        return insets;
    }

    public void setHasParticipant(boolean hasParticipant) {
        ((BorderWithLabel)this.getInnerBorder()).hasParticipant = hasParticipant;
        if (hasParticipant) {
            ((LineBorder)this.getOuterBorder()).setColor(participantSwimlaneBorderColor);
        } else {
            ((LineBorder)this.getOuterBorder()).setColor(defaultSwimlaneBorderColor);
        }
    }

    public void setDiagramMode(DiagramModeType mode) {
        ((BorderWithLabel)this.getInnerBorder()).setDiagramMode(mode);
    }

    public void setOrientation(int orientation) {
        ((BorderWithLabel)this.getInnerBorder()).setOrientation(orientation);
    }

    private static class BorderWithLabel
    extends AbstractLabeledBorder {
        public boolean hasParticipant = false;
        private Insets insets;
        private static Color defaultColor = ColorConstants.menuBackgroundSelected;
        private Insets padding = new Insets(1, 3, 2, 2);
        private Color fillColor = defaultColor;
        private int orientation = -1;
        private DiagramModeType diagramMode;
        private Insets underlineInsets;
        private IFigure button;

        public BorderWithLabel(String s, IFigure button) {
            super(s);
            this.button = button;
            this.setPadding(3);
            this.setOrientation(-1);
        }

        public void setDiagramMode(DiagramModeType mode) {
            this.diagramMode = mode;
        }

        public void setOrientation(int orientation) {
            if (-1 == orientation || -2 == orientation) {
                this.orientation = orientation;
                this.underlineInsets = -2 == orientation ? new Insets(2, 0, 2, 2) : new Insets(0, 2, 2, 2);
            }
            this.insets = null;
            this.invalidate();
        }

        public Insets getInsets(IFigure fig) {
            if (this.insets == null) {
                this.insets = this.calculateInsets(fig);
            }
            return this.insets;
        }

        protected Insets calculateInsets(IFigure figure) {
            if (this.getFont(figure) == null) {
                return new Insets(0, 0, 0, 0);
            }
            if (-2 == this.orientation) {
                return new Insets(0, this.getTextExtents((IFigure)figure).height + this.padding.getHeight(), 0, 0);
            }
            return new Insets(this.getTextExtents((IFigure)figure).height + this.padding.getHeight(), 0, 0, 0);
        }

        protected Color getBackgroundColor() {
            return this.fillColor;
        }

        protected Insets getPadding() {
            return this.padding;
        }

        public boolean isOpaque() {
            return true;
        }

        public void setBackgroundColor(Color color) {
            this.fillColor = color;
        }

        public void setPadding(int all) {
            this.padding = new Insets(all);
            this.invalidate();
        }

        public void setPadding(Insets pad) {
            this.padding = pad;
            this.invalidate();
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            int freeSpace;
            int spaceForText;
            int freeSpace2;
            int y;
            int x;
            if (figure instanceof LaneFigure) {
                if (this.hasParticipant) {
                    this.setBackgroundColor(participantSwimlaneBorderColor);
                } else {
                    this.setBackgroundColor(defaultSwimlaneBorderColor);
                }
            } else {
                this.setBackgroundColor(defaultSwimlaneBorderColor);
            }
            tempRect.setBounds(BorderWithLabel.getPaintRectangle((IFigure)figure, (Insets)insets));
            Rectangle rec = tempRect;
            if (-2 == this.orientation) {
                rec.width = Math.min(rec.width, this.getTextExtents((IFigure)figure).height + this.padding.getWidth());
            } else {
                rec.height = Math.min(rec.height, this.getTextExtents((IFigure)figure).height + this.padding.getHeight());
                g.clipRect(rec);
            }
            g.setBackgroundColor(this.fillColor);
            g.fillRectangle(rec);
            if (-2 == this.orientation) {
                x = rec.x + this.padding.right;
                y = rec.bottom() - this.padding.bottom;
            } else {
                x = rec.x + this.padding.left;
                y = rec.y + this.padding.top;
            }
            int textWidth = this.getTextExtents((IFigure)figure).width;
            boolean textToLong = false;
            if (-2 == this.orientation) {
                freeSpace2 = rec.height - this.padding.getHeight() - textWidth - ButtonSize;
                if (freeSpace2 < 0) {
                    textToLong = true;
                }
                spaceForText = rec.height - this.padding.getHeight() - ButtonSize;
            } else {
                freeSpace2 = rec.width - this.padding.getWidth() - textWidth - ButtonSize;
                if (freeSpace2 < 0) {
                    textToLong = true;
                }
                spaceForText = rec.width - this.padding.getWidth() - ButtonSize;
            }
            int newTextLength = spaceForText / 5 - 3;
            String labelToShow = new String(this.getLabel());
            if (labelToShow.length() < newTextLength) {
                newTextLength = labelToShow.length();
            }
            if (textToLong) {
                labelToShow = newTextLength > 0 ? String.valueOf(labelToShow.substring(0, newTextLength)) + "..." : "";
            }
            Dimension textExtents = FigureUtilities.getTextExtents((String)labelToShow, (Font)this.getFont(figure));
            textWidth = textExtents.width;
            if (-2 == this.orientation) {
                freeSpace = rec.height - this.padding.getHeight() - textWidth - ButtonSize / 2;
                y -= (freeSpace /= 2);
            } else {
                freeSpace = rec.width - this.padding.getWidth() - textWidth - ButtonSize / 2;
                x += (freeSpace /= 2);
            }
            g.setFont(this.getFont(figure));
            g.pushState();
            g.translate(x, y);
            if (-2 == this.orientation) {
                if (g instanceof SWTGraphics) {
                    g.rotate(270.0f);
                    g.setForegroundColor(this.getTextColor());
                    g.drawString(labelToShow, 0, 0);
                } else if (g instanceof ScaledGraphics) {
                    Image labelAsImage = ImageUtilities.createRotatedImageOfString((String)labelToShow, (Font)this.getFont(figure), (Color)this.getTextColor(), (Color)g.getBackgroundColor());
                    g.drawImage(labelAsImage, 0, 0);
                }
            } else if (-1 == this.orientation) {
                g.setForegroundColor(this.getTextColor());
                g.drawString(labelToShow, 0, 0);
            }
            g.popState();
            Rectangle bounds = BorderWithLabel.getPaintRectangle((IFigure)figure, (Insets)insets);
            if (-2 == this.orientation) {
                this.underlineInsets.left = this.getTextExtents((IFigure)figure).height + this.getPadding().getHeight() - 2;
                bounds.crop(this.underlineInsets);
            } else {
                this.underlineInsets.top = this.getTextExtents((IFigure)figure).height + this.getPadding().getHeight() - 2;
                bounds.crop(this.underlineInsets);
            }
            if (this.diagramMode.equals((Object)DiagramModeType.MODE_450_LITERAL) && this.button != null) {
                if (-2 == this.orientation) {
                    this.button.setBounds(new Rectangle(figure.getBounds().x, figure.getBounds().y, ButtonSize, ButtonSize));
                } else {
                    this.button.setBounds(new Rectangle(figure.getBounds().x + figure.getBounds().width - ButtonSize, figure.getBounds().y, ButtonSize, ButtonSize));
                }
                this.button.paint(g);
            }
        }

        public Dimension getPreferredSize(IFigure fig) {
            Dimension dimension;
            try {
                dimension = super.getPreferredSize(fig);
            }
            catch (NullPointerException nullPointerException) {
                dimension = new Dimension();
            }
            return dimension;
        }
    }
}

