/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractSwimlaneFigure;
import org.eclipse.stardust.modeling.core.editors.figures.PoolFigure;

public class SymbolContainerLayout
extends FreeformLayout {
    private int compartmentSpacing;

    public SymbolContainerLayout() {
        this.setCompartmentSpacing(3);
    }

    public int getCompartmentSpacing() {
        return this.compartmentSpacing;
    }

    public void setCompartmentSpacing(int compartmentSpacing) {
        this.compartmentSpacing = compartmentSpacing;
    }

    public void layout(IFigure parent) {
        super.layout(parent);
        Rectangle drawingArea = null;
        if (parent instanceof AbstractSwimlaneFigure) {
            drawingArea = parent.getBounds().getCopy();
            drawingArea.crop(parent.getBorder().getInsets(parent));
            parent.translateFromParent((Translatable)drawingArea);
        } else {
            for (IFigure child : parent.getChildren()) {
                if (drawingArea != null) {
                    drawingArea.union(child.getBounds());
                    continue;
                }
                drawingArea = child.getBounds().getCopy();
            }
        }
        for (IFigure child : parent.getChildren()) {
            if (!(child instanceof PoolFigure)) continue;
            Rectangle bounds = child.getBounds().getCopy();
            if (!DiagramPlugin.isVerticalModelling((IGraphicalObject)((AbstractSwimlaneFigure)child).getSwimlaneEditPart().getSwimlaneModel())) {
                bounds.x = Math.min(0, drawingArea.x);
                bounds.width = Math.max(bounds.width, drawingArea.width);
            } else {
                bounds.y = Math.min(0, drawingArea.y);
                bounds.height = Math.max(bounds.height, drawingArea.height);
            }
            child.setBounds(bounds);
        }
    }
}

