/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionEndHandle;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.handles.ConnectionStartHandle;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.Coordinates;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.RoutingType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.decoration.IDecoratablePart;
import org.eclipse.stardust.modeling.core.decoration.IDecorationProvider;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractConnectionSymbolFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IGraphicalObjectFigure;
import org.eclipse.stardust.modeling.core.editors.figures.LaneFigure;
import org.eclipse.stardust.modeling.core.editors.figures.TransitionConnectionFigure;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdaptee;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.stardust.modeling.core.editors.parts.PropertySourceFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.IHighliteableGraphicalObject;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.ConnectionBendpointEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.ConnectionSymbolComponentEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractConnectionSymbolEditPart
extends AbstractConnectionEditPart
implements NotificationAdaptee,
IHighliteableGraphicalObject,
IDecoratablePart {
    private NotificationAdapter notificationAdapter = null;
    private IPropertySource propertySource = null;
    private Color highliteBorderColor;
    private Color highliteFillColor;
    private Map decorations = new HashMap();
    private int refreshMode;

    protected AbstractConnectionSymbolEditPart(IConnectionSymbol model) {
        this.setModel(model);
    }

    private boolean canRefresh(boolean isSource, AbstractConnectionSymbolFigure acsFigure) {
        IFigure owner;
        Object connection = (Connection)this.getFigure();
        if (acsFigure != null) {
            connection = acsFigure;
        }
        ConnectionAnchor anchor = null;
        anchor = isSource ? connection.getSourceAnchor() : connection.getTargetAnchor();
        return anchor == null || (owner = anchor.getOwner()) == null || !(owner instanceof LaneFigure);
    }

    protected void refreshSourceAnchor() {
        if (this.canRefresh(true, null)) {
            super.refreshSourceAnchor();
        }
    }

    protected void refreshTargetAnchor() {
        if (this.canRefresh(false, null)) {
            super.refreshTargetAnchor();
        }
    }

    public final IConnectionSymbol getConnectionSymbolModel() {
        return (IConnectionSymbol)this.getModel();
    }

    @Override
    public void setHighliteBorderColor(Color color) {
        this.highliteBorderColor = color;
        this.refreshVisuals();
    }

    @Override
    public void resetHighliteBorderColor() {
        this.setHighliteBorderColor(null);
    }

    @Override
    public void setHighliteFillColor(Color color) {
        this.highliteFillColor = color;
        this.refreshVisuals();
    }

    @Override
    public void resetHighliteFillColor() {
        this.setHighliteFillColor(null);
    }

    protected void createEditPolicies() {
        if (!DiagramUtil.isDiagramModelElementProxy((EObject)((EObject)this.getModel()))) {
            this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy(){

                protected List createSelectionHandles() {
                    List handles = super.createSelectionHandles();
                    int i = 0;
                    while (i < handles.size()) {
                        Connection connection;
                        ConnectionAnchor anchor;
                        ConnectionHandle handle = (ConnectionHandle)handles.get(i);
                        if (handle instanceof ConnectionStartHandle && (anchor = (connection = handle.getConnection()).getSourceAnchor()).getOwner() instanceof LaneFigure) {
                            handle.setFixed(true);
                        }
                        if (handle instanceof ConnectionEndHandle && (anchor = (connection = handle.getConnection()).getTargetAnchor()).getOwner() instanceof LaneFigure) {
                            handle.setFixed(true);
                        }
                        ++i;
                    }
                    return handles;
                }
            });
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ConnectionSymbolComponentEditPolicy());
        }
    }

    protected IFigure createFigure() {
        AbstractConnectionSymbolFigure connection = new AbstractConnectionSymbolFigure();
        connection.setRouting(this.getConnectionSymbolModel().getRouting().getValue());
        return connection;
    }

    public ConnectionAnchor getSourceConnectionAnchor() {
        return super.getSourceConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor() {
        return super.getTargetConnectionAnchor();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure figure = this.getFigure();
        if (figure instanceof IGraphicalObjectFigure) {
            IGraphicalObjectFigure goFigure = (IGraphicalObjectFigure)figure;
            goFigure.setBorderColor(this.highliteBorderColor);
            goFigure.setFillColor(this.highliteFillColor);
        }
        if (figure instanceof AbstractConnectionSymbolFigure) {
            AbstractConnectionSymbolFigure acsFigure = (AbstractConnectionSymbolFigure)figure;
            if (this.canRefresh(true, acsFigure)) {
                acsFigure.setSourceAnchor(this.getSourceConnectionAnchor());
            }
            if (this.canRefresh(false, acsFigure)) {
                acsFigure.setTargetAnchor(this.getTargetConnectionAnchor());
            }
            if (figure instanceof TransitionConnectionFigure) {
                if (this.highliteBorderColor != null) {
                    ((TransitionConnectionFigure)figure).getTargetDecoration().setForegroundColor(this.highliteBorderColor);
                    ((TransitionConnectionFigure)figure).getTargetDecoration().setBackgroundColor(this.highliteBorderColor);
                } else {
                    ((TransitionConnectionFigure)figure).getTargetDecoration().setForegroundColor(TransitionConnectionFigure.FG_COLOR);
                    ((TransitionConnectionFigure)figure).getTargetDecoration().setBackgroundColor(TransitionConnectionFigure.FG_COLOR);
                }
            }
            if (RoutingType.SHORTEST_PATH_LITERAL.equals((Object)this.getRouting())) {
                acsFigure.setRouting(-1);
                this.removeEditPolicy("Connection Bendpoint Policy");
            } else if (RoutingType.MANHATTAN_LITERAL.equals((Object)this.getRouting())) {
                acsFigure.setRouting(-2);
                this.removeEditPolicy("Connection Bendpoint Policy");
            } else if (RoutingType.EXPLICIT_LITERAL.equals((Object)this.getRouting())) {
                acsFigure.setRouting(-3);
                if (!this.getConnectionSymbolModel().getCoordinates().isEmpty()) {
                    ArrayList<AbsoluteBendpoint> bendpoints = new ArrayList<AbsoluteBendpoint>(this.getConnectionSymbolModel().getCoordinates().size());
                    for (Coordinates p : this.getConnectionSymbolModel().getCoordinates()) {
                        bendpoints.add(new AbsoluteBendpoint((int)Math.round(p.getXPos()), (int)Math.round(p.getYPos())));
                    }
                    acsFigure.setRoutingConstraint(bendpoints);
                } else {
                    acsFigure.setRoutingConstraint(Collections.EMPTY_LIST);
                }
                this.installEditPolicy("Connection Bendpoint Policy", this.getConnectionBendpointEditPolicy());
                if (this.refreshMode == 0) {
                    ((ConnectionBendpointEditPolicy)this.getConnectionBendpointEditPolicy()).unSelectBendpoints();
                }
            } else {
                acsFigure.setRouting(0);
                this.removeEditPolicy("Connection Bendpoint Policy");
            }
        }
        if (this.getConnectionSymbolModel() instanceof TransitionConnectionType) {
            String expression = null;
            TransitionConnectionType tSymbol = (TransitionConnectionType)this.getConnectionSymbolModel();
            TransitionType transition = tSymbol.getTransition();
            if (transition != null) {
                if (transition.getExpression() != null) {
                    expression = ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
                    if ("true".equals(expression)) {
                        expression = null;
                    }
                } else {
                    String condition = transition.getCondition();
                    if (!"TRUE".equals(condition)) {
                        expression = condition;
                    }
                }
            }
            ((TransitionConnectionFigure)figure).setLabel(expression);
        }
    }

    protected RoutingType getRouting() {
        return this.getConnectionSymbolModel().getRouting();
    }

    private EditPolicy getConnectionBendpointEditPolicy() {
        RootEditPart root = this.getRoot();
        DiagramEditPart diagram = (DiagramEditPart)root.getContents();
        return diagram.getConnectionBendpointEditPolicy();
    }

    @Override
    public void handleNotification(Notification notification) {
        if (notification.getNotifier() instanceof IConnectionSymbol) {
            int featureId = notification.getFeatureID(CarnotWorkflowModelPackage.class);
            switch (featureId) {
                case 9: {
                    Iterator iter;
                    List list;
                    Object rawValue = notification.getNewValue();
                    if (rawValue != null) {
                        if (rawValue instanceof List) {
                            list = (List)rawValue;
                            iter = list.iterator();
                            while (iter.hasNext()) {
                                this.addNotificationAdapter((Notifier)iter.next());
                            }
                        } else {
                            this.addNotificationAdapter((Notifier)rawValue);
                        }
                    }
                    if ((rawValue = notification.getOldValue()) == null) break;
                    if (rawValue instanceof List) {
                        list = (List)rawValue;
                        iter = list.iterator();
                        while (iter.hasNext()) {
                            this.removeNotificationAdapter((Notifier)iter.next());
                        }
                        break;
                    }
                    this.removeNotificationAdapter((Notifier)rawValue);
                    break;
                }
            }
        }
        this.checkTransitionExpressionAddedOrRemoved(notification);
        this.refreshVisuals();
    }

    private void checkTransitionExpressionAddedOrRemoved(Notification notification) {
        if (notification.getNotifier() instanceof TransitionType && CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Expression().equals(notification.getFeature())) {
            if (notification.getNewValue() == null) {
                if (notification.getOldValue() != null) {
                    this.removeNotificationAdapter((Notifier)((XmlTextNode)notification.getOldValue()));
                }
            } else {
                if (notification.getOldValue() != null) {
                    this.removeNotificationAdapter((Notifier)((XmlTextNode)notification.getOldValue()));
                }
                this.addNotificationAdapter((Notifier)((XmlTextNode)notification.getNewValue()));
            }
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            IConnectionSymbol model = this.getConnectionSymbolModel();
            if (model != null) {
                model.eAdapters().add((Object)this.getNotificationAdapter());
                Iterator coordinatesIter = model.getCoordinates().iterator();
                while (coordinatesIter.hasNext()) {
                    this.addNotificationAdapter((Notifier)coordinatesIter.next());
                }
                this.cheackAddTransitionAdapters(model);
            }
        }
    }

    private void cheackAddTransitionAdapters(IConnectionSymbol model) {
        TransitionType transition;
        if (model instanceof TransitionConnectionType && (transition = ((TransitionConnectionType)model).getTransition()) != null) {
            this.addNotificationAdapter((Notifier)transition);
            XmlTextNode xmlText = transition.getExpression();
            if (xmlText != null) {
                this.addNotificationAdapter((Notifier)xmlText);
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            IConnectionSymbol model = this.getConnectionSymbolModel();
            if (model == null && this.getNotificationAdapter().getTarget() instanceof IConnectionSymbol) {
                model = (IConnectionSymbol)this.getNotificationAdapter().getTarget();
            }
            if (model != null) {
                this.checkRemoveTransitionAdapters(model);
                Iterator coordinatesIter = model.getCoordinates().iterator();
                while (coordinatesIter.hasNext()) {
                    this.removeNotificationAdapter((Notifier)coordinatesIter.next());
                }
                model.eAdapters().remove((Object)this.getNotificationAdapter());
            }
            super.deactivate();
        }
    }

    private void checkRemoveTransitionAdapters(IConnectionSymbol model) {
        TransitionType transition;
        if (model instanceof TransitionConnectionType && (transition = ((TransitionConnectionType)model).getTransition()) != null) {
            XmlTextNode xmlText = transition.getExpression();
            if (xmlText != null) {
                this.removeNotificationAdapter((Notifier)xmlText);
            }
            this.removeNotificationAdapter((Notifier)transition);
        }
    }

    public Object getAdapter(Class key) {
        if (IPropertySource.class == key) {
            return this.getPropertySource();
        }
        if (EditPart.class == key) {
            return this;
        }
        if (IModelElement.class == key || IConnectionSymbol.class == key) {
            return this.getModel();
        }
        return super.getAdapter(key);
    }

    protected NotificationAdapter getNotificationAdapter() {
        if (this.notificationAdapter == null) {
            this.notificationAdapter = new NotificationAdapter(this);
        }
        return this.notificationAdapter;
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = PropertySourceFactory.getPropertySource((EditPart)this, (EObject)this.getConnectionSymbolModel());
        }
        return this.propertySource;
    }

    private void addNotificationAdapter(Notifier notifier) {
        notifier.eAdapters().add((Object)this.getNotificationAdapter());
    }

    private void removeNotificationAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this.getNotificationAdapter());
    }

    public Command getCommand(Request request) {
        Command command = super.getCommand(request);
        return command;
    }

    public void setSelected(int value) {
        this.refreshMode = value;
        super.setSelected(value);
        this.refreshVisuals();
    }

    @Override
    public void applyDecoration(IDecorationProvider decoration) {
        IFigure decorationFigure = (IFigure)this.decorations.get(decoration.getId());
        if (decorationFigure != null) {
            if (decorationFigure.getParent() != null) {
                decorationFigure.getParent().remove(decorationFigure);
            }
            this.decorations.remove(decoration.getId());
        }
        if ((decorationFigure = decoration.createDecoration(this.getConnectionSymbolModel())) != null) {
            this.decorations.put(decoration.getId(), decorationFigure);
            LayerManager manager = (LayerManager)this.getViewer().getEditPartRegistry().get(LayerManager.ID);
            IFigure decorationLayer = manager.getLayer((Object)"BPMN Decoration Layer");
            if (decorationLayer != null && this.getFigure() != null) {
                ConnectionLocator locator = decoration.createDecorationLocator(this.getConnectionSymbolModel(), this.getConnectionFigure(), decorationFigure);
                if (locator == null) {
                    locator = new MidpointLocator(this.getConnectionFigure(), 0);
                }
                decorationLayer.add(decorationFigure, (Object)locator);
                final IFigure theDecorationFigure = decorationFigure;
                this.getFigure().addFigureListener(new FigureListener(){

                    public void figureMoved(IFigure source) {
                        theDecorationFigure.revalidate();
                    }
                });
            }
        }
    }

    @Override
    public void removeDecoration(IDecorationProvider decoration) {
        IFigure decorationFigure = (IFigure)this.decorations.get(decoration.getId());
        if (decorationFigure != null) {
            if (decorationFigure.getParent() != null) {
                decorationFigure.getParent().remove(decorationFigure);
            }
            this.decorations.remove(decoration.getId());
            decoration.decorationRemoved(this.getConnectionSymbolModel(), decorationFigure);
        }
    }
}

