/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.core.decoration.DecorationUtils;
import org.eclipse.stardust.modeling.core.decoration.IDecoratablePart;
import org.eclipse.stardust.modeling.core.decoration.IDecorationProvider;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.DiagramLayer;
import org.eclipse.stardust.modeling.core.editors.figures.SymbolContainerLayout;
import org.eclipse.stardust.modeling.core.editors.figures.routers.DiagramShortestPathConnectionRouter;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.ConnectionBendpointEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.DiagramComponentEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.SymbolContainerEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.SymbolContainerLayoutEditPolicy;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.ui.PlatformUI;

public class DiagramEditPart
extends AbstractGraphicalEditPart
implements Adapter,
IDecoratablePart {
    private EditPolicy connectionBendpointEditPolicy;
    private Notifier target;
    private PoolEditPart poolDelegate;
    private HashSet decorations = new HashSet();
    private boolean viewPool;
    private DiagramType diagram;

    public void setViewPool() {
        this.viewPool = this.diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL);
        this.refreshChildren();
    }

    public DiagramEditPart(WorkflowModelEditor editor, DiagramType model) {
        this.diagram = model;
        this.viewPool = this.diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL);
        PoolSymbol pool = DiagramUtil.getDefaultPool((DiagramType)model);
        if (pool != null) {
            this.poolDelegate = new PoolEditPart(editor, pool){

                protected void refreshChildren() {
                    DiagramEditPart.this.refreshChildren();
                }
            };
        }
        this.setModel(model);
    }

    public PoolEditPart getPoolDelegate() {
        return this.poolDelegate;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        super.addChildVisual(childEditPart, index);
        DecorationUtils.applyDecorations(childEditPart, this.decorations);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        DecorationUtils.removeDecorations(childEditPart, this.decorations);
        super.removeChildVisual(childEditPart);
    }

    public void activate() {
        if (!this.isActive()) {
            this.hookIntoModel((EObject)this.getCastedModel());
            if (this.poolDelegate != null) {
                this.poolDelegate.activate();
            }
            super.activate();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.unhookFromModel((EObject)this.getCastedModel());
            if (this.poolDelegate != null) {
                this.poolDelegate.deactivate();
            }
            super.deactivate();
        }
    }

    protected EditPolicy getConnectionBendpointEditPolicy() {
        if (this.connectionBendpointEditPolicy == null) {
            this.connectionBendpointEditPolicy = new ConnectionBendpointEditPolicy();
        }
        return this.connectionBendpointEditPolicy;
    }

    protected void createEditPolicies() {
        if (!DiagramUtil.isDiagramModelElementProxy((EObject)((EObject)this.getModel()))) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DiagramComponentEditPolicy());
            this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new SymbolContainerEditPolicy());
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SymbolContainerLayoutEditPolicy());
            this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
        }
    }

    protected IFigure createFigure() {
        DiagramLayer f = new DiagramLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new SymbolContainerLayout());
        DiagramShortestPathConnectionRouter router = new DiagramShortestPathConnectionRouter((IFigure)f);
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)router);
        return f;
    }

    private DiagramType getCastedModel() {
        return (DiagramType)this.getModel();
    }

    protected List getModelChildren() {
        ArrayList nodes = new ArrayList(this.getCastedModel().getNodes().size());
        if (this.poolDelegate != null && !this.viewPool) {
            nodes.addAll(this.poolDelegate.getModelChildren());
        } else {
            nodes.addAll(this.getCastedModel().getPoolSymbols());
            nodes.addAll(this.getCastedModel().getActivitySymbol());
            nodes.addAll(this.getCastedModel().getAnnotationSymbol());
            nodes.addAll(this.getCastedModel().getApplicationSymbol());
            nodes.addAll(this.getCastedModel().getConditionalPerformerSymbol());
            nodes.addAll(this.getCastedModel().getDataSymbol());
            nodes.addAll(this.getCastedModel().getEndEventSymbols());
            nodes.addAll(this.getCastedModel().getProcessInterfaceSymbols());
            nodes.addAll(this.getCastedModel().getGatewaySymbol());
            nodes.addAll(this.getCastedModel().getGroupSymbol());
            nodes.addAll(this.getCastedModel().getIntermediateEventSymbols());
            nodes.addAll(this.getCastedModel().getModelerSymbol());
            nodes.addAll(this.getCastedModel().getOrganizationSymbol());
            nodes.addAll(this.getCastedModel().getProcessSymbol());
            nodes.addAll(this.getCastedModel().getRoleSymbol());
            nodes.addAll(this.getCastedModel().getStartEventSymbols());
            nodes.addAll(this.getCastedModel().getTextSymbol());
        }
        return nodes;
    }

    public Object getAdapter(Class key) {
        Object result = null;
        if (SnapToHelper.class.equals((Object)key)) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>(3);
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGeometry.isEnabled"))) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.snapGridMode")) {
                if (Boolean.TRUE.equals(this.getViewer().getProperty("ruler$visibility"))) {
                    snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
                }
                if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGrid.isEnabled"))) {
                    snapStrategies.add((Object)new SnapCenterToGrid((GraphicalEditPart)this));
                }
            }
            if (1 == snapStrategies.size()) {
                return snapStrategies.get(0);
            }
            if (1 < snapStrategies.size()) {
                result = new CompoundSnapToHelper(snapStrategies.toArray(new SnapToHelper[snapStrategies.size()]));
            }
        } else {
            if (IModelElement.class.equals((Object)key)) {
                return this.getModel();
            }
            result = super.getAdapter(key);
        }
        return result;
    }

    @Override
    public void applyDecoration(IDecorationProvider decoration) {
        DecorationUtils.applyDecoration(decoration, this.getChildren());
        this.decorations.add(decoration);
    }

    @Override
    public void removeDecoration(IDecorationProvider decoration) {
        DecorationUtils.removeDecoration(decoration, this.getChildren());
        this.decorations.remove(decoration);
    }

    private void hookIntoModel(EObject model) {
        if (model != null) {
            model.eAdapters().add((Object)this);
        }
    }

    private void unhookFromModel(EObject model) {
        if (model != null) {
            model.eAdapters().remove((Object)this);
        }
    }

    public void notifyChanged(Notification notification) {
        int type = notification.getEventType();
        int featureId = notification.getFeatureID(CarnotWorkflowModelPackage.class);
        PoolSymbol poolSymbol = DiagramUtil.getDefaultPool((DiagramType)((DiagramType)this.getModel()));
        switch (featureId) {
            case 34: {
                this.setViewPool();
                this.refresh();
                List children = new ArrayList();
                if (this.viewPool) {
                    if (!this.getChildren().isEmpty()) {
                        children = ((PoolEditPart)this.getChildren().get(0)).getChildren();
                    }
                } else {
                    children = this.getChildren();
                }
                for (AbstractNodeSymbolEditPart element : children) {
                    if (!(element instanceof SymbolGroupEditPart)) continue;
                    ((SymbolGroupEditPart)element).refreshGroupChildren();
                }
                break;
            }
            case 33: {
                if (poolSymbol != null) {
                    this.viewPool = false;
                    int height = poolSymbol.getHeight();
                    int width = poolSymbol.getWidth();
                    poolSymbol.setHeight(width);
                    poolSymbol.setWidth(height);
                    this.refresh();
                    this.setViewPool();
                }
                this.refresh();
            }
        }
        if (type == 3 || type == 4) {
            switch (featureId) {
                case 27: {
                    for (EditPart element : this.getChildren()) {
                        element.refresh();
                    }
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 32: {
                    this.refreshChildren();
                }
            }
        }
    }

    public Notifier getTarget() {
        return this.target;
    }

    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    public boolean isAdapterForType(Object type) {
        return this.getModel().getClass() == type;
    }
}

