/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkColor;
import org.eclipse.stardust.model.xpdl.carnot.LinkEndStyle;
import org.eclipse.stardust.model.xpdl.carnot.LinkLineStyle;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.swt.graphics.Color;

public class GenericLinkConnectionEditPart
extends AbstractConnectionSymbolEditPart {
    private static final Color[] COLOR_MAPPING = new Color[]{ColorConstants.black, ColorConstants.darkBlue, ColorConstants.darkGray, ColorConstants.blue, ColorConstants.lightGray, ColorConstants.red, ColorConstants.yellow};
    private static final int[] STYLE_MAPPING = new int[]{1, 3, 2};
    public static final PointList RHOMBUS = new PointList();
    private Label nameLabel;
    private Label sourceRoleLabel;
    private Label targetRoleLabel;

    static {
        RHOMBUS.addPoint(0, 0);
        RHOMBUS.addPoint(-1, 1);
        RHOMBUS.addPoint(-2, 0);
        RHOMBUS.addPoint(-1, -1);
    }

    protected GenericLinkConnectionEditPart(GenericLinkConnectionType model) {
        super((IConnectionSymbol)model);
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            GenericLinkConnectionType link = (GenericLinkConnectionType)this.getModel();
            LinkTypeType type = link.getLinkType();
            if (type != null) {
                type.eAdapters().add((Object)this.getNotificationAdapter());
            }
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            GenericLinkConnectionType link = (GenericLinkConnectionType)this.getModel();
            LinkTypeType type = link.getLinkType();
            if (type != null) {
                type.eAdapters().remove((Object)this.getNotificationAdapter());
            }
            super.deactivate();
        }
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        PolylineConnection pLine = (PolylineConnection)this.getFigure();
        GenericLinkConnectionType link = (GenericLinkConnectionType)this.getModel();
        LinkTypeType type = link.getLinkType();
        if (type != null) {
            pLine.setForegroundColor(this.getLineColor(type.getLineColor()));
            pLine.setLineStyle(this.getLineStyle(type.getLineStyle()));
            pLine.setSourceDecoration(this.getDecoration(type.getSourceSymbol()));
            pLine.setTargetDecoration(this.getDecoration(type.getTargetSymbol()));
            this.nameLabel = this.setLabel(this.nameLabel, pLine, this.normalizeLabel(type.getName()), type.isShowLinkTypeName(), 4, true);
            this.sourceRoleLabel = this.setLabel(this.sourceRoleLabel, pLine, this.normalizeLabel(type.getSourceRole()), type.isShowRoleNames(), 2, false);
            this.targetRoleLabel = this.setLabel(this.targetRoleLabel, pLine, this.normalizeLabel(type.getTargetRole()), type.isShowRoleNames(), 3, false);
        }
    }

    private Label setLabel(Label label, PolylineConnection pLine, String name, boolean show, int align, boolean border) {
        if (name == null || !show) {
            if (label != null) {
                pLine.remove((IFigure)label);
                label = null;
            }
        } else if (label == null) {
            label = new Label(name);
            label.setBackgroundColor(ColorConstants.listBackground);
            if (border) {
                label.setOpaque(true);
                label.setBorder((Border)new LineBorder());
            }
            pLine.add((IFigure)label, (Object)new ConnectionLocator((Connection)pLine, align));
        } else {
            label.setText(name);
        }
        return label;
    }

    private String normalizeLabel(String name) {
        return name == null || name.trim().length() == 0 ? null : " " + name.trim() + " ";
    }

    private RotatableDecoration getDecoration(LinkEndStyle sourceSymbol) {
        PolygonDecoration decoration = null;
        if (sourceSymbol != null) {
            switch (sourceSymbol.getValue()) {
                case 4: {
                    decoration = new PolygonDecoration();
                    decoration.setTemplate(RHOMBUS);
                    decoration.setBackgroundColor(ColorConstants.listBackground);
                    break;
                }
                case 2: {
                    decoration = new PolygonDecoration();
                    decoration.setBackgroundColor(ColorConstants.listBackground);
                    break;
                }
                case 5: {
                    decoration = new PolygonDecoration();
                    decoration.setTemplate(RHOMBUS);
                    break;
                }
                case 3: {
                    decoration = new PolygonDecoration();
                    break;
                }
                case 1: {
                    decoration = new PolylineDecoration();
                }
            }
        }
        return decoration;
    }

    private Color getLineColor(LinkColor color) {
        Color lineColor = ColorConstants.gray;
        if (color != null && color.getValue() >= 0 && color.getValue() < COLOR_MAPPING.length) {
            lineColor = COLOR_MAPPING[color.getValue()];
        }
        return lineColor;
    }

    private int getLineStyle(LinkLineStyle style) {
        int lineStyle = 1;
        if (style != null && style.getValue() >= 0 && style.getValue() < STYLE_MAPPING.length) {
            lineStyle = STYLE_MAPPING[style.getValue()];
        }
        return lineStyle;
    }
}

