/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.AbstractMultiPageGraphicalEditor;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.utils.HierarchyUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractPasteAction
extends SelectionAction {
    protected Clipboard clipboard;
    protected List copySet;
    protected ModelType targetModel;
    protected StoreObject storage;
    protected DiagramModeType targetDiagramMode;
    protected boolean copyLanes = false;
    protected boolean sameModel = false;
    protected Integer isValid = null;

    protected AbstractPasteAction(IWorkbenchPart part) {
        super(part);
    }

    protected boolean isValidSelection() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (!(part instanceof WorkflowModelEditor)) {
            return false;
        }
        this.copyLanes = false;
        Object currentContent = this.clipboard.getContents();
        if (!(currentContent instanceof List)) {
            return false;
        }
        ArrayList content = new ArrayList((List)currentContent);
        this.copySet = this.extractStorage(content);
        List selection = this.getSelectedObjects();
        if (selection == null || selection.size() == 0 || selection.size() > 1) {
            return false;
        }
        this.targetModel = CopyPasteUtil.getTargetModel(this.getSelectedObjects().get(0));
        if (this.targetModel == null) {
            return false;
        }
        this.sameModel = this.storage.getSourceModel().equals(this.targetModel);
        this.isValid = CopyPasteUtil.validateSelection(this.copySet, false);
        return this.isValid != null;
    }

    protected List extractStorage(List currentContent) {
        ArrayList copySet = new ArrayList();
        int i = 0;
        while (i < currentContent.size()) {
            Object entry = currentContent.get(i);
            if (entry instanceof StoreObject) {
                this.storage = (StoreObject)entry;
            } else {
                copySet.add(entry);
            }
            ++i;
        }
        return copySet;
    }

    protected boolean isValidForDiagram() {
        Object selectedObject = this.getSelectedObjects().get(0);
        if (selectedObject instanceof EditPart) {
            DiagramEditPart diagramEP = null;
            DiagramType diagram = null;
            if (selectedObject instanceof DiagramEditPart || selectedObject instanceof DiagramRootEditPart) {
                if (selectedObject instanceof DiagramEditPart) {
                    diagramEP = (DiagramEditPart)selectedObject;
                } else if (selectedObject instanceof DiagramRootEditPart) {
                    diagramEP = (DiagramEditPart)((DiagramRootEditPart)((Object)selectedObject)).getChildren().get(0);
                }
                if (diagramEP != null) {
                    diagram = (DiagramType)diagramEP.getModel();
                }
                this.storage.setTargetDiagram(diagram);
                if (ModelUtils.findContainingProcess((EObject)diagram) != null) {
                    this.targetDiagramMode = diagram.getMode();
                }
            }
            if (diagramEP != null) {
                if (this.copySet.get(0) instanceof LaneSymbol) {
                    this.copyLanes = true;
                }
                if (ModelUtils.findContainingProcess((EObject)diagram) != null) {
                    if (this.isValid == 3) {
                        return false;
                    }
                    Object targetEP = PoolLaneUtils.findTargetEditPart((WorkflowModelEditor)this.getWorkbenchPart());
                    if (targetEP != null && targetEP instanceof LaneEditPart || targetEP instanceof PoolEditPart || targetEP instanceof DiagramEditPart || targetEP instanceof DiagramRootEditPart) {
                        if (targetEP instanceof DiagramRootEditPart || targetEP instanceof DiagramEditPart) {
                            targetEP = diagramEP;
                        }
                        if (targetEP instanceof LaneEditPart && ((LaneEditPart)targetEP).getLaneFigure().isCollapsed()) {
                            return false;
                        }
                        if (this.targetDiagramMode.equals((Object)DiagramModeType.MODE_450_LITERAL)) {
                            if (PoolLaneUtils.containsLanes(targetEP) && !this.copyLanes) {
                                return false;
                            }
                            if (targetEP instanceof DiagramEditPart) {
                                return false;
                            }
                            if (this.copyLanes) {
                                IModelParticipant parentParticipant;
                                EObject model;
                                if (PoolLaneUtils.containsOthers((AbstractSwimlaneEditPart)targetEP)) {
                                    return false;
                                }
                                DiagramEditorPage diagramEditorPage = (DiagramEditorPage)((AbstractMultiPageGraphicalEditor)this.getWorkbenchPart()).getCurrentPage();
                                Point mouseLocation = diagramEditorPage.getMouseLocation();
                                if (targetEP.getModel() != null && (model = (EObject)targetEP.getModel()).eContainer() == null) {
                                    return false;
                                }
                                Point newContainerLocation = PoolLaneUtils.getLocation((GraphicalEditPart)targetEP, ((AbstractGraphicalEditPart)targetEP).getFigure(), mouseLocation, true);
                                if (!PoolLaneUtils.isSensitiveArea((AbstractSwimlaneEditPart)targetEP, newContainerLocation)) {
                                    return false;
                                }
                                ISwimlaneSymbol targetSymbol = (ISwimlaneSymbol)targetEP.getModel();
                                if (!this.sameModel) {
                                    if (targetSymbol instanceof LaneSymbol && HierarchyUtils.hasParentLanesParticipant((LaneSymbol)targetSymbol) != null) {
                                        int i = 0;
                                        while (i < this.copySet.size()) {
                                            LaneSymbol symbol = (LaneSymbol)this.copySet.get(i);
                                            if (symbol.getParticipantReference() != null || HierarchyUtils.hasChildLanesParticipant(symbol)) {
                                                return false;
                                            }
                                            ++i;
                                        }
                                    }
                                } else if (targetSymbol instanceof LaneSymbol && (parentParticipant = HierarchyUtils.hasParentLanesParticipant((LaneSymbol)targetSymbol)) != null) {
                                    ModelType model2 = (ModelType)((AbstractNodeEditPart)targetEP).getEditor().getModel();
                                    Map organizationTree = HierarchyUtils.createHierarchy(model2);
                                    List organizationChildren = null;
                                    if (parentParticipant instanceof OrganizationType) {
                                        organizationChildren = HierarchyUtils.getChildHierarchy(organizationTree, (OrganizationType)parentParticipant);
                                    }
                                    int l = 0;
                                    while (l < this.copySet.size()) {
                                        LaneSymbol laneCopy = (LaneSymbol)this.copySet.get(l);
                                        IModelParticipant laneCopyParticipant = laneCopy.getParticipantReference();
                                        ArrayList<IModelParticipant> childParticipants = null;
                                        if (laneCopyParticipant == null) {
                                            childParticipants = HierarchyUtils.getTopLevelChildParticipants(laneCopy);
                                        } else {
                                            childParticipants = new ArrayList<IModelParticipant>();
                                            childParticipants.add(laneCopyParticipant);
                                        }
                                        if (childParticipants != null) {
                                            if (organizationChildren == null) {
                                                return false;
                                            }
                                            int o = 0;
                                            while (childParticipants.size() > 0) {
                                                IModelParticipant childParticipant = (IModelParticipant)childParticipants.get(o);
                                                if (!organizationChildren.contains(childParticipant)) {
                                                    return false;
                                                }
                                                ++o;
                                            }
                                        }
                                        ++l;
                                    }
                                }
                            }
                        } else if (this.copyLanes) {
                            return false;
                        }
                        this.storage.setTargetEditPart((EditPart)targetEP);
                        if (!this.targetDiagramMode.equals((Object)DiagramModeType.MODE_450_LITERAL) && targetEP instanceof DiagramEditPart) {
                            targetEP = ((DiagramEditPart)targetEP).getPoolDelegate();
                            this.storage.setTargetObject((EObject)targetEP.getModel());
                        } else {
                            this.storage.setTargetObject((EObject)targetEP.getModel());
                        }
                        return true;
                    }
                } else {
                    if (this.copyLanes) {
                        return false;
                    }
                    Object targetEP = PoolLaneUtils.findTargetEditPart((WorkflowModelEditor)this.getWorkbenchPart());
                    if (targetEP != null && targetEP instanceof PoolEditPart || targetEP instanceof DiagramEditPart || targetEP instanceof DiagramRootEditPart) {
                        if (targetEP instanceof DiagramRootEditPart) {
                            targetEP = diagramEP;
                        }
                        if (this.isValid == 4) {
                            return false;
                        }
                        this.storage.setTargetEditPart((EditPart)targetEP);
                        this.storage.setTargetObject((EObject)targetEP.getModel());
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isValidForOutline() {
        if (CopyPasteUtil.isTypeDeclarationsNode(this.getSelectedObjects().get(0))) {
            return CopyPasteUtil.isTypeDeclarationOnly(this.copySet);
        }
        if (CopyPasteUtil.isDataCategoryNode(this.getSelectedObjects().get(0))) {
            return CopyPasteUtil.isDataOnly(this.copySet);
        }
        if (CopyPasteUtil.isParticipantCategoryNode(this.getSelectedObjects().get(0))) {
            return CopyPasteUtil.isParticipantOnly(this.copySet);
        }
        if (CopyPasteUtil.isApplicationCategoryNode(this.getSelectedObjects().get(0))) {
            return CopyPasteUtil.isApplicationOnly(this.copySet);
        }
        if (CopyPasteUtil.isProcessCategoryNode(this.getSelectedObjects().get(0)) != null) {
            ProcessDefinitionType selectedProcess = CopyPasteUtil.isProcessCategoryNode(this.getSelectedObjects().get(0));
            if (this.sameModel && CopyPasteUtil.isProcessDiagramOnly(this.copySet, selectedProcess, this.storage.getSourceModel())) {
                return true;
            }
            return CopyPasteUtil.isProcessChildOnly(this.copySet);
        }
        if (CopyPasteUtil.isModelCategoryNode(this.getSelectedObjects().get(0))) {
            if (!this.sameModel && CopyPasteUtil.containsDiagram(this.copySet)) {
                return false;
            }
            if (CopyPasteUtil.containsProcessChild(this.copySet)) {
                return false;
            }
            return !CopyPasteUtil.containsProcessDiagram(this.copySet);
        }
        return false;
    }

    protected EObject getTargetObject() {
        Object targetEP = this.getSelectedObjects().get(0);
        EObject targetObject = null;
        if (targetEP instanceof EditPart) {
            DiagramEditPart diagramEP = null;
            if (targetEP instanceof DiagramRootEditPart) {
                diagramEP = (DiagramEditPart)((DiagramRootEditPart)((Object)targetEP)).getChildren().get(0);
            } else if (targetEP instanceof DiagramEditPart) {
                diagramEP = (DiagramEditPart)targetEP;
            }
            if (diagramEP != null) {
                targetObject = (EObject)diagramEP.getModel();
            }
        }
        return targetObject;
    }
}

