/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AutomaticIdentifierDialog
extends Dialog {
    private Text idText;
    private Button performCheckBox;
    private Button autoPerformCheckBox;
    private String id;
    private String iconPath;
    private String type;
    private boolean perform = false;
    private boolean autoPerform = false;
    private Object container;
    private Map counters = new HashMap();
    private boolean canAutoPerform;

    protected AutomaticIdentifierDialog(Shell parentShell, boolean canAutoPerform) {
        super(parentShell);
        this.canAutoPerform = canAutoPerform;
        this.perform = !canAutoPerform;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Diagram_Messages.TXT_WR);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        Image image = DiagramPlugin.getImage(this.iconPath);
        Label iconLabel = FormBuilder.createLabel((Composite)composite, (String)"");
        iconLabel.setImage(image);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LBL_NULL, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)MessageFormat.format(Diagram_Messages.LBL_HAS_NO_ID, this.type), (int)3);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.idText = FormBuilder.createText((Composite)composite, (int)2);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AutomaticIdentifierDialog.this.id = AutomaticIdentifierDialog.this.idText.getText();
            }
        });
        this.performCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BOX_GENERATE_AUTOMATIC_ID, (int)2);
        this.performCheckBox.setSelection(this.perform);
        this.performCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AutomaticIdentifierDialog.this.perform = AutomaticIdentifierDialog.this.performCheckBox.getSelection();
                AutomaticIdentifierDialog.this.autoPerformCheckBox.setSelection(false);
                AutomaticIdentifierDialog.this.autoPerformCheckBox.setVisible(AutomaticIdentifierDialog.this.perform && AutomaticIdentifierDialog.this.canAutoPerform);
                AutomaticIdentifierDialog.this.updateId();
            }
        });
        this.autoPerformCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)this.getAutoPerformCheckBoxText(), (int)3);
        this.autoPerformCheckBox.setSelection(this.autoPerform);
        this.autoPerformCheckBox.setVisible(this.perform && this.canAutoPerform);
        this.autoPerformCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AutomaticIdentifierDialog.this.autoPerform = AutomaticIdentifierDialog.this.autoPerformCheckBox.getSelection();
            }
        });
        this.updateId();
        return composite;
    }

    private String getAutoPerformCheckBoxText() {
        return this.canAutoPerform ? Diagram_Messages.BOX_TXT_APPLY_TO_ALL_MISSING_ID_S : Diagram_Messages.BOX_TXT_APPLY_TO_ALL_SIMILAR_ISSUES_IN_THIS_MD;
    }

    public void updateId() {
        if (this.perform) {
            int[] count = (int[])this.counters.get(this.container);
            if (count == null) {
                if (this.container instanceof List) {
                    IdFactory factory = new IdFactory(this.type, null);
                    factory.computeNames((List)this.container);
                    this.id = factory.getId();
                    if (!this.type.equals(this.id)) {
                        try {
                            count = new int[]{Integer.parseInt(this.id.substring(this.id.lastIndexOf(95) + 1)) - 1};
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                if (count == null) {
                    count = new int[1];
                }
                this.counters.put(this.container, count);
            }
            count[0] = count[0] + 1;
            this.id = String.valueOf(this.type) + '_' + count[0];
            if (!this.idText.isDisposed()) {
                this.idText.setText(this.id);
            }
        }
    }

    public void initialize(Object container, String iconPath, String type, boolean autoReplace) {
        this.container = container;
        this.iconPath = iconPath;
        this.type = type;
        this.autoPerform = autoReplace;
    }

    public String getId() {
        return this.id;
    }

    public boolean getAutoPerform() {
        return this.autoPerform;
    }
}

