/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.LaneUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyAction
extends SelectionAction {
    private Clipboard clipboard;
    private WorkflowModelEditor editor;
    private Integer isValid;

    public CopyAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.editor = editor;
        this.setId(ActionFactory.COPY.getId());
        this.setText(Diagram_Messages.LB_CopyElement);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setToolTipText(Diagram_Messages.LB_CopyElement);
        this.setAccelerator(262211);
        this.clipboard = Clipboard.getDefault();
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        if (CopyPasteUtil.containsGateway(selection)) {
            return false;
        }
        this.isValid = CopyPasteUtil.validateSelection(selection, false);
        if (this.isValid == null) {
            return false;
        }
        if (this.getSelectedObjects().get(0) instanceof LaneEditPart) {
            LaneSymbol symbol;
            LaneEditPart child;
            HashMap<LaneSymbol, List> laneHierarchies = new HashMap<LaneSymbol, List>();
            int i = 0;
            while (i < this.getSelectedObjects().size()) {
                child = (LaneEditPart)this.getSelectedObjects().get(i);
                symbol = child.getLaneModel();
                List hierarchy = LaneUtils.createLaneHierarchy(symbol);
                if (hierarchy == null) {
                    return false;
                }
                laneHierarchies.put(symbol, hierarchy);
                ++i;
            }
            i = 0;
            while (i < this.getSelectedObjects().size()) {
                child = (LaneEditPart)this.getSelectedObjects().get(i);
                symbol = child.getLaneModel();
                for (Map.Entry entry : laneHierarchies.entrySet()) {
                    LaneSymbol checkLane = (LaneSymbol)entry.getKey();
                    List checkHierarchy = (List)entry.getValue();
                    if (symbol.equals(checkLane) || !LaneUtils.containsLane(checkHierarchy, symbol)) continue;
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void run() {
        List contentList = CopyPasteUtil.createCopySet(this.isValid, this.getSelectedObjects(), this.editor, false);
        this.clipboard.setContents((Object)contentList);
    }
}

