/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateTypedModelElementCommand;
import org.eclipse.ui.IWorkbenchPart;

public class CreateTriggerAction
extends SelectionAction {
    private IConfigurationElement config;
    protected IModelElement trigger;

    public CreateTriggerAction(IConfigurationElement config, WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.config = config;
        this.setId("org.eclipse.stardust.modeling.core.createTrigger." + config.getAttribute("id"));
        this.setText(config.getAttribute("name"));
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor(config));
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.getProcess() != null;
    }

    public void run() {
        this.execute(this.createCommand());
        CreationUtils.showInOutlineAndEdit((EObject)this.trigger);
    }

    private Command createCommand() {
        IdFactory id = new IdFactory(this.config.getAttribute("id"), this.config.getAttribute("name"));
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateMetaTypeCommand(this.config, CarnotWorkflowModelPackage.eINSTANCE.getTriggerTypeType(), new EStructuralFeature[0]));
        command.add(new CreateTypedModelElementCommand(1, id, this.config.getAttribute("id"), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_TriggerType(), CarnotWorkflowModelPackage.eINSTANCE.getTriggerType()){

            @Override
            protected IModelElement createModelElement() {
                IModelElement element;
                CreateTriggerAction.this.trigger = element = super.createModelElement();
                return element;
            }
        });
        command.setParent((EObject)this.getProcess());
        return command;
    }

    private ProcessDefinitionType getProcess() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ProcessDefinitionType) {
            return (ProcessDefinitionType)model;
        }
        return null;
    }
}

