/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AnnotationSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.GenericLinkConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.RefersToConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.TextSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.utils.CheckDeleteConnections;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteAllAction
extends DeleteAction {
    public DeleteAllAction(IWorkbenchPart part) {
        super(part);
        this.setText(Diagram_Messages.TXT_DeleteAll);
        this.setToolTipText(Diagram_Messages.TXT_DeleteAll);
        this.setLazyEnablementCalculation(true);
    }

    protected boolean calculateEnabled() {
        return super.calculateEnabled() && !this.getSelectedObjects().isEmpty() && this.isValidSelection(this.getSelectedObjects());
    }

    private boolean isValidSelection(List<Object> selectedObjects) {
        for (Object object : selectedObjects) {
            if (object instanceof AnnotationSymbolEditPart || object instanceof TextSymbolEditPart || object instanceof SymbolGroupEditPart || object instanceof ChildCategoryNode || object instanceof RefersToConnectionEditPart || object instanceof GenericLinkConnectionEditPart || object instanceof ModelTreeEditPart || object instanceof DiagramRootEditPart || object instanceof DiagramEditPart || this.isPredefinedData(object) || object instanceof EditPart && ((EditPart)object).getModel() instanceof IObjectDescriptor) {
                return false;
            }
            if (!(object instanceof PoolEditPart) || !DiagramUtil.isDefaultPool((ISwimlaneSymbol)((PoolEditPart)object).getPoolModel())) continue;
            return false;
        }
        return true;
    }

    private boolean isPredefinedData(Object obj) {
        if (obj instanceof EditPart) {
            if (((EditPart)obj).getModel() instanceof DataType) {
                return ((DataType)((EditPart)obj).getModel()).isPredefined();
            }
            if (((EditPart)obj).getModel() instanceof DataSymbolType) {
                DataType data = ((DataSymbolType)((EditPart)obj).getModel()).getData();
                return data != null && ((DataSymbolType)((EditPart)obj).getModel()).getData().isPredefined();
            }
        }
        return false;
    }

    public void run() {
        if (this.getSelectedObjects().size() == 1) {
            WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
            if (!CheckDeleteConnections.checkConnections(this.getSelectedObjects(), editor, false)) {
                return;
            }
        }
        if (MessageDialog.openConfirm(null, (String)Diagram_Messages.MSG_ConfirmDelete, (String)Diagram_Messages.MSG_SureToDeleteElement)) {
            super.run();
        }
    }
}

