/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteSymbolCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.utils.CheckDeleteConnections;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteSymbolAction
extends SelectionAction {
    private CompoundCommand cmd;

    public DeleteSymbolAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.deleteSymbol");
        this.setText(Diagram_Messages.LB_ACTION_RemoveSymbol);
    }

    protected boolean calculateEnabled() {
        boolean canExecute = false;
        if (this.checkSymbols()) {
            Command cmd = this.createDeleteCommand(this.getSelectedObjects());
            if (cmd == null) {
                return false;
            }
            canExecute = cmd.canExecute();
        }
        return canExecute;
    }

    private boolean checkSymbols() {
        boolean hasDeletableSymbols = false;
        boolean isGatewaySymbol = true;
        boolean isPseudoConnection = false;
        boolean isTreeSymbol = true;
        boolean isSwimlane = true;
        boolean isDiagram = true;
        for (Object selectedObj : this.getSelectedObjects()) {
            if (!(selectedObj instanceof EditPart)) continue;
            Object element = ((EditPart)selectedObj).getModel();
            isGatewaySymbol = element instanceof GatewaySymbol;
            if (element instanceof TransitionConnectionType) {
                TransitionConnectionType trans = (TransitionConnectionType)element;
                isPseudoConnection = trans.getTransition() == null && (trans.getSourceActivitySymbol() instanceof GatewaySymbol || trans.getTargetActivitySymbol() instanceof GatewaySymbol);
            }
            isTreeSymbol = selectedObj instanceof AbstractEObjectTreeEditPart;
            isDiagram = selectedObj instanceof DiagramEditPart;
            isSwimlane = selectedObj instanceof AbstractSwimlaneEditPart;
            if (isGatewaySymbol || isPseudoConnection || isTreeSymbol || isSwimlane || isDiagram) {
                return false;
            }
            hasDeletableSymbols = true;
        }
        return hasDeletableSymbols;
    }

    public void run() {
        Command command;
        if (this.getSelectedObjects().size() == 1) {
            WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
            if (!CheckDeleteConnections.checkConnections(this.getSelectedObjects(), editor, true)) {
                this.cmd = null;
                return;
            }
        }
        if ((command = this.createDeleteCommand(this.getSelectedObjects())).canExecute()) {
            this.execute(command);
        }
    }

    public Command createDeleteCommand(List<EditPart> objects) {
        this.cmd = new CompoundCommand();
        if (objects.isEmpty()) {
            return null;
        }
        for (EditPart editPart : objects) {
            if (editPart instanceof AbstractConnectionEditPart) {
                this.cmd.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)editPart.getModel()));
                continue;
            }
            if (!(editPart instanceof AbstractNodeSymbolEditPart)) continue;
            this.cmd.add(DeleteSymbolCommandFactory.createDeleteSymbolCommand((INodeSymbol)editPart.getModel()));
        }
        return this.cmd;
    }
}

