/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DistributeRequest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DistributeAction
extends SelectionAction {
    public static final String REQ_DISTRIBUTE = Diagram_Messages.REQ_DISTRIBUTE;
    public static final String DISTRIBUTE_HORIZONTAL_LABEL = Diagram_Messages.DISTRIBUTE_HORIZONTAL_LABEL;
    public static final String DISTRIBUTE_VERTICAL_LABEL = Diagram_Messages.DISTRIBUTE_VERTICAL_LABEL;
    private int direction;
    private List operationSet;

    public DistributeAction(IWorkbenchPart part, int direction) {
        super(part);
        this.direction = direction;
        this.initUI();
    }

    protected boolean calculateEnabled() {
        this.operationSet = null;
        Command cmd = this.createDistributeCommand(false, false);
        return cmd != null;
    }

    public void dispose() {
        this.operationSet = Collections.EMPTY_LIST;
        super.dispose();
    }

    public void run() {
        this.operationSet = null;
        boolean isSnapToGrid = this.isSnapToGridEnabled();
        boolean oneSymbolGrid = false;
        if (isSnapToGrid) {
            DistributionGridDialog dialog = new DistributionGridDialog();
            if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureprompt")) {
                dialog.open();
                if (dialog.getReturnCode() == 0 && dialog.getToggleState()) {
                    PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureprompt", false);
                    PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureallSymbols", !dialog.isOneSymbolSnapToGrid());
                    PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureoneSymbol", dialog.isOneSymbolSnapToGrid());
                } else if (dialog.getReturnCode() != 0) {
                    return;
                }
            }
            oneSymbolGrid = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureprompt") ? dialog.isOneSymbolSnapToGrid() : PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureoneSymbol");
        }
        this.execute(this.createDistributeCommand(oneSymbolGrid, isSnapToGrid));
    }

    private Command createDistributeCommand(boolean oneSymbolGrid, boolean isSnapToGrid) {
        DistributeRequest request = new DistributeRequest();
        List editparts = this.getOperationSet((Request)request);
        if (editparts.size() < 3) {
            return null;
        }
        PrecisionRectangle distRect = this.calculateDistributionRectangle(editparts);
        Dimension existing = this.calculateTotalDimension(editparts);
        double deltaX = (distRect.preciseWidth - (double)existing.width) / ((double)editparts.size() - 1.0);
        double deltaY = (distRect.preciseHeight - (double)existing.height) / ((double)editparts.size() - 1.0);
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(0);
        PrecisionRectangle rect = new PrecisionRectangle(part.getFigure().getBounds());
        part.getFigure().translateToAbsolute((Translatable)rect);
        double px = rect.preciseRight() + deltaX;
        double py = rect.preciseBottom() + deltaY;
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getText());
        PrecisionPoint snapDelta = new PrecisionPoint(0, 0);
        if (isSnapToGrid && oneSymbolGrid) {
            EditPart lastSelectedPart = (EditPart)editparts.get(editparts.size() - 1);
            SnapToHelper snapToHelper = (SnapToHelper)lastSelectedPart.getParent().getAdapter(SnapToHelper.class);
            request = new DistributeRequest();
            PrecisionRectangle baseRect = new PrecisionRectangle(((GraphicalEditPart)lastSelectedPart).getFigure().getBounds());
            snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, snapDelta);
            request.setMoveDelta((Point)snapDelta);
            command.add(lastSelectedPart.getCommand((Request)request));
            request = new DistributeRequest();
            request.setMoveDelta((Point)snapDelta);
            command.add(((EditPart)editparts.get(0)).getCommand((Request)request));
        }
        int i = 1;
        while (i < editparts.size() - 1) {
            PrecisionPoint delta;
            part = (GraphicalEditPart)editparts.get(i);
            request = new DistributeRequest();
            rect = new PrecisionRectangle(part.getFigure().getBounds());
            part.getFigure().translateToAbsolute((Translatable)rect);
            PrecisionPoint precisionPoint = delta = this.direction == 64 ? new PrecisionPoint(px - rect.preciseX, 0.0) : new PrecisionPoint(0.0, py - rect.preciseY);
            if (isSnapToGrid && !oneSymbolGrid) {
                snapDelta = new PrecisionPoint(0, 0);
                SnapToHelper snapToHelper = (SnapToHelper)part.getParent().getAdapter(SnapToHelper.class);
                Rectangle movedRect = new Rectangle(part.getFigure().getBounds()).getTranslated((Point)delta);
                if (snapToHelper != null) {
                    snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{new PrecisionRectangle(movedRect)}, snapDelta);
                }
            }
            PrecisionPoint snapDistDelta = new PrecisionPoint(delta.x + snapDelta.x, delta.y + snapDelta.y);
            request.setMoveDelta((Point)snapDistDelta);
            px += rect.preciseWidth + deltaX;
            py += rect.preciseHeight + deltaY;
            command.add(part.getCommand((Request)request));
            ++i;
        }
        return command;
    }

    private boolean isSnapToGridEnabled() {
        return Boolean.TRUE.equals(((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGrid.isEnabled")) && (Boolean.FALSE.equals(((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGeometry.isEnabled")) || ((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGeometry.isEnabled") == null);
    }

    private Dimension calculateTotalDimension(List editparts) {
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(0);
        Dimension dim = new Dimension(part.getFigure().getBounds().getSize());
        int i = 1;
        while (i < editparts.size()) {
            part = (GraphicalEditPart)editparts.get(i);
            Dimension dim2 = new Dimension(part.getFigure().getBounds().getSize());
            dim.expand(dim2);
            ++i;
        }
        return dim;
    }

    private PrecisionRectangle calculateDistributionRectangle(List editparts) {
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(0);
        PrecisionRectangle rect = new PrecisionRectangle(part.getFigure().getBounds());
        part.getFigure().translateToAbsolute((Translatable)rect);
        int i = 1;
        while (i < editparts.size()) {
            part = (GraphicalEditPart)editparts.get(i);
            PrecisionRectangle rect2 = new PrecisionRectangle(part.getFigure().getBounds());
            part.getFigure().translateToAbsolute((Translatable)rect2);
            rect.union(rect2);
            ++i;
        }
        return rect;
    }

    protected List getOperationSet(Request request) {
        if (this.operationSet != null) {
            return this.operationSet;
        }
        List editparts = new ArrayList(this.getSelectedObjects());
        if (editparts.isEmpty() || !(editparts.get(0) instanceof GraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        editparts = ToolUtilities.getSelectionWithoutDependants(editparts);
        ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)request);
        if (editparts.size() < 3) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        Collections.sort(editparts, new Comparator(){

            public int compare(Object o1, Object o2) {
                Point p1 = DistributeAction.this.getCenter((GraphicalEditPart)o1);
                Point p2 = DistributeAction.this.getCenter((GraphicalEditPart)o2);
                return DistributeAction.this.direction == 64 ? p1.x - p2.x : p1.y - p2.y;
            }
        });
        return editparts;
    }

    private Point getCenter(GraphicalEditPart part1) {
        Rectangle rect1 = new Rectangle(part1.getFigure().getBounds());
        part1.getFigure().translateToAbsolute((Translatable)rect1);
        return rect1.getCenter();
    }

    protected void initUI() {
        switch (this.direction) {
            case 64: {
                this.setId("org.eclipse.stardust.modeling.core.distributeHorizontal");
                this.setText(DISTRIBUTE_HORIZONTAL_LABEL);
                break;
            }
            case 128: {
                this.setId("org.eclipse.stardust.modeling.core.distributeVertical");
                this.setText(DISTRIBUTE_VERTICAL_LABEL);
            }
        }
    }

    private class DistributionGridDialog
    extends MessageDialogWithToggle {
        private Button oneSymbolRadio;
        private boolean isOneSymbolSnapToGrid;

        public DistributionGridDialog() {
            super(null, Diagram_Messages.TITLE_SnapToGrid, null, "", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, Diagram_Messages.LB_RememberDecision, false);
        }

        protected Control createMessageArea(Composite composite) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                this.imageLabel.setLayoutData((Object)new GridData(66));
            }
            Group group = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.LB_SnapToGrid, (int)2);
            ((GridLayout)composite.getLayout()).horizontalSpacing = 15;
            this.oneSymbolRadio = FormBuilder.createRadioButton((Composite)group, (String)Diagram_Messages.LB_LastSelectedSymbol);
            this.oneSymbolRadio.setSelection(true);
            FormBuilder.createRadioButton((Composite)group, (String)Diagram_Messages.LB_AllMovedSymbols);
            return composite;
        }

        protected void okPressed() {
            this.setReturnCode(0);
            this.isOneSymbolSnapToGrid = this.oneSymbolRadio.getSelection();
            this.close();
        }

        public boolean isOneSymbolSnapToGrid() {
            return this.isOneSymbolSnapToGrid;
        }
    }
}

