/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractConnectionSymbolFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.IActiveAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteSymbolCommandFactory;
import org.eclipse.ui.IWorkbenchPart;

public class OptimizeDiagramAction
extends SelectionAction
implements IActiveAction {
    public OptimizeDiagramAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.initUI();
    }

    protected boolean calculateEnabled() {
        DiagramType diagram;
        if (this.getSelectedObjects().size() == 1 && (diagram = this.getDiagram()) != null) {
            TreeIterator itr = this.getDiagram().eAllContents();
            while (itr.hasNext()) {
                Object item = itr.next();
                if (!(item instanceof IModelElementNodeSymbol) && !(item instanceof IFlowObjectSymbol) || !this.hasMultipleConnections((INodeSymbol)item, true) && !this.hasMultipleConnections((INodeSymbol)item, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void run() {
        HashMap<IIdentifiableModelElement, HashSet<INodeSymbol>> identifiables = new HashMap<IIdentifiableModelElement, HashSet<INodeSymbol>>();
        HashSet removedConnections = new HashSet();
        CompoundCommand command = new CompoundCommand();
        TreeIterator contentsIterator = this.getDiagram().eAllContents();
        while (contentsIterator.hasNext()) {
            Object item = contentsIterator.next();
            if (!(item instanceof IModelElementNodeSymbol) && !(item instanceof IFlowObjectSymbol)) continue;
            INodeSymbol symbol = (INodeSymbol)item;
            this.removeMultipleConnections(command, removedConnections, symbol, true);
            this.removeMultipleConnections(command, removedConnections, symbol, false);
            if (!(item instanceof IModelElementNodeSymbol)) continue;
            IIdentifiableModelElement identifiable = ((IModelElementNodeSymbol)item).getModelElement();
            HashSet<INodeSymbol> symbols = (HashSet<INodeSymbol>)identifiables.get(identifiable);
            if (symbols == null) {
                symbols = new HashSet<INodeSymbol>();
                identifiables.put(identifiable, symbols);
            }
            symbols.add(symbol);
        }
        for (Set symbols : identifiables.values()) {
            if (symbols.size() <= 1) continue;
            Iterator symbolsIterator = symbols.iterator();
            while (symbolsIterator.hasNext()) {
                INodeSymbol symbol = (INodeSymbol)symbolsIterator.next();
                if (this.hasConnections(symbol, removedConnections, true) || this.hasConnections(symbol, removedConnections, false) || !symbolsIterator.hasNext()) continue;
                command.add(DeleteSymbolCommandFactory.createDeleteSymbolCommand(symbol));
            }
        }
        this.execute((Command)command);
    }

    private boolean hasConnections(INodeSymbol symbol, Set removedConnections, boolean outgoing) {
        EList links;
        List features = outgoing ? symbol.getOutConnectionFeatures() : symbol.getInConnectionFeatures();
        int i = 0;
        while (i < features.size()) {
            List connections;
            EStructuralFeature feature = (EStructuralFeature)features.get(i);
            if (feature.isMany() && this.hasConnections(removedConnections, connections = (List)symbol.eGet(feature))) {
                return true;
            }
            ++i;
        }
        EList eList = links = outgoing ? symbol.getOutLinks() : symbol.getInLinks();
        return this.hasConnections(removedConnections, (List)links);
    }

    private boolean hasConnections(Set removedConnections, List links) {
        for (IConnectionSymbol connection : links) {
            if (removedConnections.contains(connection)) continue;
            return true;
        }
        return false;
    }

    private void removeMultipleConnections(CompoundCommand command, Set removedConnections, INodeSymbol symbol, boolean outgoing) {
        List features = outgoing ? symbol.getOutConnectionFeatures() : symbol.getInConnectionFeatures();
        int i = 0;
        while (i < features.size()) {
            EStructuralFeature feature = (EStructuralFeature)features.get(i);
            if (feature.isMany()) {
                List connections = (List)symbol.eGet(feature);
                this.removeConnections(command, removedConnections, connections, symbol, outgoing);
            }
            ++i;
        }
        EList links = outgoing ? symbol.getOutLinks() : symbol.getInLinks();
        this.removeConnections(command, removedConnections, (List)links, symbol, outgoing);
    }

    private void removeConnections(CompoundCommand command, Set removedConnections, List connections, INodeSymbol symbol, boolean outgoing) {
        HashSet<INodeSymbol> symbols = new HashSet<INodeSymbol>();
        HashMap<IIdentifiableModelElement, IConnectionSymbol> connectionsMap = new HashMap<IIdentifiableModelElement, IConnectionSymbol>();
        int j = 0;
        while (j < connections.size()) {
            IConnectionSymbol connection = (IConnectionSymbol)connections.get(j);
            if (!removedConnections.contains(connection)) {
                INodeSymbol target;
                INodeSymbol iNodeSymbol = target = outgoing ? connection.getTargetNode() : connection.getSourceNode();
                if (target == symbol) {
                    INodeSymbol iNodeSymbol2 = target = outgoing ? connection.getSourceNode() : connection.getTargetNode();
                }
                if (symbols.contains(target)) {
                    command.add((Command)new DeleteConnectionSymbolCmd(connection));
                    removedConnections.add(connection);
                } else if (target instanceof IModelElementNodeSymbol) {
                    IIdentifiableModelElement identifiable = ((IModelElementNodeSymbol)target).getModelElement();
                    IConnectionSymbol otherConnection = (IConnectionSymbol)connectionsMap.get(identifiable);
                    if (otherConnection == null) {
                        connectionsMap.put(identifiable, connection);
                    } else {
                        double otherLength;
                        double length = this.getLength(connection);
                        if (length < (otherLength = this.getLength(otherConnection))) {
                            connectionsMap.put(identifiable, connection);
                            connection = otherConnection;
                        }
                        command.add((Command)new DeleteConnectionSymbolCmd(connection));
                        removedConnections.add(connection);
                    }
                }
                symbols.add(target);
            }
            ++j;
        }
    }

    private double getLength(IConnectionSymbol connection) {
        double length = 0.0;
        WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
        ConnectionEditPart editPart = (ConnectionEditPart)editor.findEditPart(connection);
        if (editPart != null) {
            AbstractConnectionSymbolFigure figure = (AbstractConnectionSymbolFigure)editPart.getFigure();
            length = figure.getStart().getDistance(figure.getEnd());
        }
        return length;
    }

    private boolean hasMultipleConnections(INodeSymbol symbol, boolean outgoing) {
        EList links;
        List features = outgoing ? symbol.getOutConnectionFeatures() : symbol.getInConnectionFeatures();
        int i = 0;
        while (i < features.size()) {
            List connections;
            EStructuralFeature feature = (EStructuralFeature)features.get(i);
            if (feature.isMany() && this.isMultiple(symbol, connections = (List)symbol.eGet(feature), outgoing)) {
                return true;
            }
            ++i;
        }
        EList eList = links = outgoing ? symbol.getOutLinks() : symbol.getInLinks();
        return this.isMultiple(symbol, (List)links, outgoing);
    }

    private boolean isMultiple(INodeSymbol symbol, List connections, boolean outgoing) {
        HashSet<IIdentifiableModelElement> identifiables = new HashSet<IIdentifiableModelElement>();
        HashSet<INodeSymbol> symbols = new HashSet<INodeSymbol>();
        int j = 0;
        while (j < connections.size()) {
            INodeSymbol target;
            IConnectionSymbol connection = (IConnectionSymbol)connections.get(j);
            INodeSymbol iNodeSymbol = target = outgoing ? connection.getTargetNode() : connection.getSourceNode();
            if (target == symbol) {
                INodeSymbol iNodeSymbol2 = target = outgoing ? connection.getSourceNode() : connection.getTargetNode();
            }
            if (symbols.contains(target)) {
                return true;
            }
            if (target instanceof IModelElementNodeSymbol) {
                IIdentifiableModelElement identifiable = ((IModelElementNodeSymbol)target).getModelElement();
                if (identifiables.contains(identifiable)) {
                    return true;
                }
                identifiables.add(identifiable);
            }
            symbols.add(target);
            ++j;
        }
        return false;
    }

    private DiagramType getDiagram() {
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof DiagramRootEditPart) {
            selection = ((DiagramRootEditPart)((Object)selection)).getContents();
        }
        if (!(selection instanceof EditPart)) {
            return null;
        }
        Object element = ((EditPart)selection).getModel();
        if (element instanceof DiagramType) {
            return (DiagramType)element;
        }
        return null;
    }

    protected void initUI() {
        super.init();
        this.setId("org.eclipse.stardust.modeling.core.optimize");
        this.setText(Diagram_Messages.TXT_SimplifyDiagram);
        this.setLazyEnablementCalculation(false);
    }

    protected void handleSelectionChanged() {
    }

    @Override
    public boolean isActive() {
        this.refresh();
        return this.isEnabled();
    }
}

