/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.ui.IWorkbenchPart;

public class RefreshConnectionObjectAction
extends SelectionAction {
    private List<Connection> selectedConnections;

    public RefreshConnectionObjectAction(WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.setId("org.eclipse.stardust.modeling.repository.common.refresh");
        this.setText(Diagram_Messages.TXT_REFRESH);
    }

    protected boolean calculateEnabled() {
        this.selectedConnections = this.getSelectedConnections();
        return this.selectedConnections != null;
    }

    private List<Connection> getSelectedConnections() {
        if (this.getSelectedObjects().size() == 0) {
            return null;
        }
        List selection = this.getSelectedObjects();
        ArrayList<Connection> result = new ArrayList<Connection>();
        int i = 0;
        while (i < selection.size()) {
            Object entry = this.getSelectedObjects().get(i);
            if (entry instanceof EditPart) {
                Object model = ((EditPart)entry).getModel();
                if (model instanceof Connection) {
                    result.add((Connection)model);
                } else {
                    return null;
                }
            }
            ++i;
        }
        return result.size() == 0 ? null : result;
    }

    public void run() {
        for (Connection connection : this.selectedConnections) {
            this.connectionPropertiesChanged(connection);
        }
    }

    protected void connectionPropertiesChanged(Connection connection) {
        ConnectionManager manager = ConnectionManager.getConnectionManager((Connection)connection);
        if (manager != null) {
            try {
                manager.close(connection);
            }
            catch (CoreException coreException) {}
            connection.eNotify((Notification)new NotificationImpl(4, null, null, 0));
        }
    }
}

