/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ActivityCommandFactory;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;

public class SetActivityImplementationAction
extends Action {
    private ActivityType activity;
    private EditDomain domain;
    private ActivityImplementationType implType;

    public SetActivityImplementationAction(ActivityImplementationType implType, ActivityType activity, EditDomain domain) {
        super(ModelUtils.getActivityImplementationTypeText((ActivityImplementationType)implType));
        this.implType = implType;
        this.activity = activity;
        this.domain = domain;
    }

    public void run() {
        IModelParticipant performer = null;
        AttributeType auxiliaryAttr = AttributeUtil.getAttribute((IExtensibleElement)this.activity, (String)"isAuxiliaryActivity");
        CompoundCommand cmd = new CompoundCommand();
        cmd.add(ActivityCommandFactory.getSetImplementationCommand(this.implType, this.activity));
        if (this.implType.equals((Object)ActivityImplementationType.MANUAL_LITERAL) && (performer = GenericUtils.getLanePerformerForActivity(this.activity)) != null) {
            cmd.add((Command)new SetValueCmd((EObject)this.activity, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_Performer(), (Object)performer));
        }
        if (!ActivityUtil.isInteractive((ActivityType)this.activity, (ActivityImplementationType)this.implType) && this.activity.getPerformer() != null) {
            cmd.add((Command)new SetValueCmd((EObject)this.activity, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_Performer(), null));
        }
        if (!this.implType.equals((Object)ActivityImplementationType.APPLICATION_LITERAL) && this.activity.getApplication() != null) {
            cmd.add((Command)new SetValueCmd((EObject)this.activity, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_Application(), null));
        }
        if (auxiliaryAttr != null) {
            cmd.add((Command)new DeleteValueCmd(auxiliaryAttr.eContainer(), auxiliaryAttr, auxiliaryAttr.eContainingFeature()));
        }
        this.domain.getCommandStack().execute((Command)cmd);
    }

    public ActivityImplementationType getImplType() {
        return this.implType;
    }
}

