/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.ui.IWorkbenchPart;

public class SetDefaultSizeAction
extends SelectionAction {
    public static final String SET_DEFAULT_SIZE_LABEL = Diagram_Messages.SetDefaultSizeAction_Label;

    public SetDefaultSizeAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.setDefaultSize");
        this.setText(SET_DEFAULT_SIZE_LABEL);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createSetDefaultSizeCommand();
        if (cmd == null) {
            return false;
        }
        Object part = this.getSelectedObjects().get(0);
        if (part instanceof AbstractGraphicalEditPart && SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)part) != null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        this.execute(this.createSetDefaultSizeCommand());
    }

    private Command createSetDefaultSizeCommand() {
        List editparts = this.getSelectedObjects();
        if (editparts.isEmpty()) {
            return null;
        }
        return this.createSetDefaultSizeCommand(editparts);
    }

    private Command createSetDefaultSizeCommand(List editparts) {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            Object part = editparts.get(i);
            if (part instanceof GraphicalEditPart) {
                this.addCommand(command, ((GraphicalEditPart)part).getModel());
            }
            ++i;
        }
        return command.unwrap();
    }

    private void addCommand(CompoundCommand command, Object model) {
        if (model instanceof ISymbolContainer) {
            ISymbolContainer container = (ISymbolContainer)model;
            CompoundCommand cmd = new CompoundCommand();
            cmd.setDebugLabel(container.eClass().getName());
            FeatureMap nodes = container.getNodes();
            int i = 0;
            while (i < nodes.size()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)nodes.get(i);
                this.addCommand(cmd, entry.getValue());
                ++i;
            }
            if (!cmd.isEmpty()) {
                command.add((Command)cmd);
            }
        } else if (model instanceof INodeSymbol) {
            int defHeigth;
            int defWidth;
            INodeSymbol symbol = (INodeSymbol)model;
            CompoundCommand cmd = new CompoundCommand();
            cmd.setDebugLabel(symbol.eClass().getName());
            int n = defWidth = symbol instanceof GatewaySymbol ? 40 : -1;
            if (symbol.getWidth() != defWidth) {
                cmd.add((Command)new SetValueCmd((EObject)symbol, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_Width(), (Object)new Integer(defWidth)));
            }
            int n2 = defHeigth = symbol instanceof GatewaySymbol ? 40 : -1;
            if (symbol.getHeight() != defHeigth) {
                cmd.add((Command)new SetValueCmd((EObject)symbol, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_Height(), (Object)new Integer(defHeigth)));
            }
            if (!cmd.isEmpty()) {
                command.add((Command)cmd);
            }
        }
    }
}

