/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.SelectionPopup;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;

public class ShowInDiagramAction
extends SelectionAction {
    private WorkflowModelEditor editor;

    public ShowInDiagramAction(IWorkbenchPart part) {
        super(part);
        this.editor = (WorkflowModelEditor)part;
        this.setText(Diagram_Messages.LB_ShowInDiagram);
        this.setToolTipText(Diagram_Messages.LB_ShowInDiagram);
        this.setId("org.eclipse.stardust.modeling.core.showInDiagramAction");
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/diagram.gif"));
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        if (selection.size() != 1) {
            return false;
        }
        Object element = this.getSelectedObjects().get(0);
        if (!(element instanceof AbstractEObjectTreeEditPart) && !(element instanceof IModelElement)) {
            return false;
        }
        List symbols = this.getSymbols(element);
        return symbols.size() > 0;
    }

    private Set getDiagrams(Object element) {
        HashSet<DiagramType> diagrams = new HashSet<DiagramType>();
        List symbols = this.getSymbols(element);
        for (Object symbol : symbols) {
            DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)symbol));
            diagrams.add(diagram);
        }
        return diagrams;
    }

    private List getSymbols(Object element) {
        Object modelElement = null;
        if (element instanceof AbstractEObjectTreeEditPart) {
            modelElement = ((AbstractEditPart)element).getModel();
        } else if (element instanceof IModelElement) {
            modelElement = element;
        }
        if (modelElement instanceof ApplicationType || modelElement instanceof DataType || modelElement instanceof IModelParticipant || modelElement instanceof ActivityType || modelElement instanceof TriggerType || modelElement instanceof LinkTypeType || modelElement instanceof ProcessDefinitionType) {
            return ((IIdentifiableModelElement)modelElement).getSymbols();
        }
        if (modelElement instanceof TransitionType) {
            return ((TransitionType)modelElement).getTransitionConnections();
        }
        return Collections.EMPTY_LIST;
    }

    private List getSymbolsForDiagram(List symbols, DiagramType diagram) {
        ArrayList diagramSymbols = new ArrayList();
        for (Object symbol : symbols) {
            DiagramType symbolDiagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)symbol));
            if (!symbolDiagram.equals(diagram)) continue;
            diagramSymbols.add(symbol);
        }
        return diagramSymbols;
    }

    public void run() {
        DiagramType diagram;
        Object element = this.getSelectedObjects().get(0);
        List symbols = this.getSymbols(element);
        Set diagrams = this.getDiagrams(element);
        if (diagrams.size() > 1) {
            List diagramSymbols;
            SelectionPopup popup = new SelectionPopup(this.editor.getSite().getShell());
            popup.setContentProvider((IContentProvider)new ArrayContentProvider());
            popup.setLabelProvider((ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof EObject) {
                        return DiagramPlugin.getImage(ShowInDiagramAction.this.editor.getIconFactory().getIconFor((EObject)element));
                    }
                    return super.getImage(element);
                }

                public String getText(Object element) {
                    if (element instanceof DiagramType) {
                        String diagramName = ((DiagramType)element).getName();
                        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)((EObject)element));
                        if (process != null) {
                            return String.valueOf(diagramName) + " (" + process.getName() + ")";
                        }
                        return diagramName;
                    }
                    return super.getText(element);
                }
            });
            popup.setInput((Object)diagrams);
            diagram = (DiagramType)popup.open();
            if (diagram == null) {
                return;
            }
            symbols = diagramSymbols = this.getSymbolsForDiagram(symbols, diagram);
        } else {
            Object[] content = diagrams.toArray();
            diagram = (DiagramType)content[0];
        }
        this.editor.selectSymbols(symbols, diagram);
    }
}

