/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.ui.IWorkbenchPart;

public class ShowInOutlineAction
extends SelectionAction {
    private WorkflowModelEditor editor;

    public ShowInOutlineAction(IWorkbenchPart part) {
        super(part);
        this.editor = (WorkflowModelEditor)part;
        this.setText(Diagram_Messages.LB_ShowInOutline);
        this.setToolTipText(Diagram_Messages.LB_ShowInOutline);
        this.setId("org.eclipse.stardust.modeling.core.showInOutlineAction");
    }

    protected boolean calculateEnabled() {
        if (this.editor.getOutlinePage().getControl() == null) {
            return false;
        }
        List selection = this.getSelectedObjects();
        if (selection.size() != 1) {
            return false;
        }
        Object element = this.getSelectedObjects().get(0);
        if (element instanceof AbstractModelElementNodeSymbolEditPart || element instanceof AbstractConnectionSymbolEditPart) {
            if (element instanceof AbstractConnectionSymbolEditPart) {
                IConnectionSymbol symbol = (IConnectionSymbol)((AbstractConnectionSymbolEditPart)element).getModel();
                if (symbol instanceof TransitionConnectionType && ((TransitionConnectionType)symbol).getTransition() != null) {
                    return true;
                }
                if (symbol instanceof GenericLinkConnectionType && ((GenericLinkConnectionType)symbol).getLinkType() != null) {
                    return true;
                }
            } else {
                INodeSymbol symbol = (INodeSymbol)((AbstractModelElementNodeSymbolEditPart)element).getModel();
                if (symbol instanceof IModelElementNodeSymbol && ((IModelElementNodeSymbol)symbol).getModelElement() != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public void run() {
        Object element = this.getSelectedObjects().get(0);
        TransitionType select = null;
        if (element instanceof AbstractConnectionSymbolEditPart) {
            IConnectionSymbol symbol = (IConnectionSymbol)((AbstractConnectionSymbolEditPart)element).getModel();
            if (symbol instanceof TransitionConnectionType) {
                select = ((TransitionConnectionType)symbol).getTransition();
            } else if (symbol instanceof GenericLinkConnectionType) {
                select = ((GenericLinkConnectionType)symbol).getLinkType();
            }
        } else {
            INodeSymbol symbol = (INodeSymbol)((AbstractModelElementNodeSymbolEditPart)element).getModel();
            if (symbol instanceof IModelElementNodeSymbol) {
                select = ((IModelElementNodeSymbol)symbol).getModelElement();
            }
        }
        this.editor.selectInOutline((EObject)select);
    }
}

