/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.ActivitySymbolFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegateCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateDiagramAction
extends SelectionAction {
    public UpdateDiagramAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.initUI();
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.getDiagram() != null && this.createUpdateDiagramCommand(this.getDiagram()).canExecute();
    }

    public void run() {
        this.execute(this.createUpdateDiagramCommand(this.getDiagram()));
    }

    public void runEmbedded(DelegateCommand compound) {
        compound.setDelegate(this.createUpdateDiagramCommand(this.getDiagram()));
    }

    protected Command createUpdateDiagramCommand(DiagramType diagram) {
        CompoundCommand command = new CompoundCommand();
        if (diagram != null) {
            List activitySymbols = this.getActivitySymbols(diagram);
            int i = 0;
            while (i < activitySymbols.size()) {
                ActivitySymbolType symbol;
                ActivityType activity;
                if (activitySymbols.get(i) instanceof ActivitySymbolType && (activity = (symbol = (ActivitySymbolType)activitySymbols.get(i)).getActivity()) != null) {
                    if (activity.getJoin() != JoinSplitType.NONE_LITERAL && !this.hasGateway(diagram, symbol, FlowControlType.JOIN_LITERAL)) {
                        this.createGatewayCommand(command, symbol, FlowControlType.JOIN_LITERAL);
                    }
                    if (activity.getSplit() != JoinSplitType.NONE_LITERAL && !this.hasGateway(diagram, symbol, FlowControlType.SPLIT_LITERAL)) {
                        this.createGatewayCommand(command, symbol, FlowControlType.SPLIT_LITERAL);
                    }
                }
                ++i;
            }
        }
        return command;
    }

    private List getActivitySymbols(DiagramType diagram) {
        return DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), null);
    }

    private void createGatewayCommand(CompoundCommand command, final ActivitySymbolType symbol, final FlowControlType flowType) {
        Command gatewayCommand;
        int symbolHeight;
        final GatewaySymbol[] gateway = new GatewaySymbol[1];
        IdFactory id = new IdFactory("Gateway", Diagram_Messages.BASENAME_Gateway);
        CreateSymbolCommand cmd = new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getGatewaySymbol()){

            @Override
            protected IModelElement createModelElement() {
                gateway[0] = (GatewaySymbol)super.createModelElement();
                gateway[0].setFlowKind(flowType);
                gateway[0].setActivitySymbol(symbol);
                return gateway[0];
            }
        };
        cmd.setParent(symbol.eContainer());
        ActivitySymbolFigure[] figure = new ActivitySymbolFigure[1];
        int symbolWidth = symbol.getWidth();
        if (symbolWidth <= 0) {
            symbolWidth = this.getActivitySymbolFigure((ActivitySymbolFigure[])figure, (ActivityType)symbol.getActivity()).getPreferredSize().width;
        }
        if ((symbolHeight = symbol.getHeight()) <= 0) {
            symbolHeight = this.getActivitySymbolFigure((ActivitySymbolFigure[])figure, (ActivityType)symbol.getActivity()).getPreferredSize().height;
        }
        int size = 40;
        Dimension delta = this.getGatewayDelta(flowType, new Dimension(symbolWidth, symbolHeight), size);
        cmd.setLocation(new Rectangle((int)symbol.getXPos() + delta.width, (int)symbol.getYPos() + delta.height, size, size));
        command.add((Command)cmd);
        ActivitySymbolType[] activity = new ActivitySymbolType[]{symbol};
        if (flowType.getValue() == 1) {
            this.setTargetSymbol(command, (List)symbol.getInTransitions(), gateway);
            this.createTransitionConnection(command, ModelUtils.findContainingDiagram((IGraphicalObject)symbol), (IFlowObjectSymbol[])gateway, (IFlowObjectSymbol[])activity);
        }
        if (flowType.getValue() == 2) {
            this.setSourceSymbol(command, (List)symbol.getOutTransitions(), gateway);
            this.createTransitionConnection(command, ModelUtils.findContainingDiagram((IGraphicalObject)symbol), (IFlowObjectSymbol[])activity, (IFlowObjectSymbol[])gateway);
        }
        if ((gatewayCommand = this.createGatewayUpdateCommand(gateway)) != null) {
            command.add(gatewayCommand);
        }
    }

    public Command createGatewayUpdateCommand(GatewaySymbol[] gateway) {
        return null;
    }

    protected Dimension getGatewayDelta(FlowControlType flowType, Dimension activitySize, int gatewaySize) {
        int width = flowType.getValue() == 1 ? -3 * gatewaySize / 2 : activitySize.width + gatewaySize / 2;
        int height = (activitySize.height - gatewaySize) / 2;
        return new Dimension(width, height);
    }

    private void createTransitionConnection(CompoundCommand command, DiagramType diagram, final IFlowObjectSymbol[] source, final IFlowObjectSymbol[] target) {
        IdFactory id = new IdFactory(Diagram_Messages.ID_TransitionConnection, Diagram_Messages.BASENAME_TransitionConnection);
        CreateConnectionSymbolCommand createCmd = new CreateConnectionSymbolCommand(id, CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType()){

            @Override
            public INodeSymbol getSourceSymbol() {
                return source[0];
            }

            @Override
            public INodeSymbol getTargetSymbol() {
                return target[0];
            }
        };
        createCmd.setParent((EObject)diagram);
        command.add((Command)createCmd);
    }

    private void setSourceSymbol(CompoundCommand command, List transitions, final GatewaySymbol[] symbol) {
        int i = 0;
        while (i < transitions.size()) {
            TransitionConnectionType ts = (TransitionConnectionType)transitions.get(i);
            command.add((Command)new SetValueCmd((EObject)ts, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType_SourceActivitySymbol(), null){

                @Override
                public Object getValue() {
                    return symbol[0];
                }
            });
            ++i;
        }
    }

    private void setTargetSymbol(CompoundCommand command, List transitions, final GatewaySymbol[] symbol) {
        int i = 0;
        while (i < transitions.size()) {
            TransitionConnectionType ts = (TransitionConnectionType)transitions.get(i);
            command.add((Command)new SetValueCmd((EObject)ts, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType_TargetActivitySymbol(), null){

                @Override
                public Object getValue() {
                    return symbol[0];
                }
            });
            ++i;
        }
    }

    private ActivitySymbolFigure getActivitySymbolFigure(ActivitySymbolFigure[] figure, ActivityType activity) {
        if (figure[0] == null) {
            figure[0] = new ActivitySymbolFigure();
            figure[0].setFont(this.getFont());
            if (activity != null) {
                if (activity.getName() != null) {
                    figure[0].setName(activity.getName());
                } else if (activity.getId() != null) {
                    figure[0].setName(activity.getId());
                }
                figure[0].setIconPath(((WorkflowModelEditor)this.getWorkbenchPart()).getIconFactory().getIconFor((EObject)activity));
            }
            figure[0].validate();
        }
        return figure[0];
    }

    private Font getFont() {
        DiagramEditPart editPart;
        WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
        DiagramEditPart diagramEditPart = editPart = editor.getCurrentPage() instanceof DiagramEditorPage ? (DiagramEditPart)((DiagramEditorPage)editor.getCurrentPage()).getGraphicalViewer().getRootEditPart().getChildren().get(0) : null;
        if (editPart != null) {
            return editPart.getFigure().getFont();
        }
        return editor.getSite().getShell().getFont();
    }

    private boolean hasGateway(DiagramType diagram, ActivitySymbolType target, FlowControlType flow) {
        List gateways = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_GatewaySymbol(), null);
        int i = 0;
        while (i < gateways.size()) {
            GatewaySymbol gateway = (GatewaySymbol)gateways.get(i);
            if (flow.equals((Object)gateway.getFlowKind()) && gateway.getActivitySymbol() != null && gateway.getActivitySymbol().equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private DiagramType getDiagram() {
        Object selection = this.getSelectedObjects().get(0);
        if (!(selection instanceof EditPart)) {
            return null;
        }
        Object element = ((EditPart)selection).getModel();
        if (element instanceof DiagramType) {
            return (DiagramType)element;
        }
        return null;
    }

    protected void initUI() {
        super.init();
        this.setId("org.eclipse.stardust.modeling.core.update");
        this.setText(Diagram_Messages.TXT_UpdateDiagram);
    }
}

