/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.jobs.ModelValidationJob;
import org.eclipse.ui.IWorkbenchPart;

public class ValidateModelAction
extends SelectionAction {
    private WorkflowModelEditor editor;

    public ValidateModelAction(WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
        this.setId("org.eclipse.stardust.modeling.core.validateModel");
        this.setText(Diagram_Messages.TXT_ValidateModel);
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.getModel() != null;
    }

    public void run() {
        ModelValidationJob validationJob = new ModelValidationJob(this.editor, this.getModel(), this.createPerspectiveFilter());
        if (validationJob.getModelFile() != null) {
            validationJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(validationJob.getModelFile()));
            validationJob.schedule();
        }
    }

    private Map createPerspectiveFilter() {
        HashMap<String, String> filters = new HashMap<String, String>();
        String perspectiveId = DiagramPlugin.getViewAsPerspectiveId((WorkflowModelEditor)this.getWorkbenchPart());
        if (perspectiveId != null) {
            filters.put("perspectiveType", perspectiveId);
        }
        return filters;
    }

    private ModelType getModel() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ModelType) {
            return (ModelType)model;
        }
        return null;
    }
}

