/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;

public class AddNodeSymbolCommand
extends Command {
    private ISymbolContainer diagram;
    private INodeSymbol nodeSymbol;
    private IModelElement nodeModel;
    private EObject modelContainer;
    private EStructuralFeature modelContainmentFeature;
    private EStructuralFeature symbolContainmentFeature;
    private Long modelElementOidBackup;
    private Long symbolElementOidBackup;

    public void setDiagram(ISymbolContainer targetLane) {
        this.diagram = targetLane;
    }

    public void setNodeSymbol(INodeSymbol flowObject, EStructuralFeature containmentFeature) {
        this.nodeSymbol = flowObject;
        this.symbolContainmentFeature = containmentFeature;
    }

    public void setNodeModel(IModelElement nodeModel, EObject container, EStructuralFeature containmentFeature) {
        this.nodeModel = nodeModel;
        this.modelContainer = container;
        this.modelContainmentFeature = containmentFeature;
    }

    public void execute() {
        if (this.nodeModel != null) {
            this.modelElementOidBackup = this.nodeModel.isSetElementOid() ? new Long(this.nodeModel.getElementOid()) : null;
        }
        this.symbolElementOidBackup = this.nodeSymbol.isSetElementOid() ? new Long(this.nodeSymbol.getElementOid()) : null;
        this.redo();
    }

    public void redo() {
        if (this.nodeSymbol != null) {
            if (this.nodeModel != null) {
                if (this.modelContainer == null || this.modelContainmentFeature == null) {
                    throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingNodeModelContainer) + this.nodeModel);
                }
                EList modelContainment = (EList)this.modelContainer.eGet(this.modelContainmentFeature);
                modelContainment.add((Object)this.nodeModel);
            }
            if (this.diagram == null || this.symbolContainmentFeature == null) {
                throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingNodeSymbolContainer) + this.nodeSymbol);
            }
            EList symbolContainment = (EList)this.diagram.eGet(this.symbolContainmentFeature);
            symbolContainment.add((Object)this.nodeSymbol);
        }
    }

    public void undo() {
        if (this.nodeSymbol != null) {
            if (this.diagram == null || this.symbolContainmentFeature == null) {
                throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingNodeSymbolContainer) + this.nodeSymbol);
            }
            EList symbolContainment = (EList)this.diagram.eGet(this.symbolContainmentFeature);
            symbolContainment.remove((Object)this.nodeSymbol);
            if (this.nodeModel != null) {
                if (this.modelContainer == null || this.modelContainmentFeature == null) {
                    throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingNodeModelContainer) + this.nodeModel);
                }
                EList modelContainment = (EList)this.modelContainer.eGet(this.modelContainmentFeature);
                modelContainment.remove((Object)this.nodeModel);
            }
        }
    }
}

