/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.Arrays;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.Coordinates;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.modeling.core.Diagram_Messages;

public class ConnectionBendpointsCommand
extends Command {
    private static final int CMD_INSERT_BENDPOINT = -1;
    private static final int CMD_MOVE_BENDPOINT = -2;
    private static final int CMD_REMOVE_BENDPOINT = -3;
    private static final int CMD_REMOVE_ALL_BENDPOINTS = -4;
    private final int cmdKind;
    private final IConnectionSymbol target;
    private int index;
    private Point location;
    private Coordinates[] coordinatesBackup;

    public static ConnectionBendpointsCommand insertBendpoint(IConnectionSymbol connection, Point location, int insertAt) {
        ConnectionBendpointsCommand result = new ConnectionBendpointsCommand(-1, connection);
        result.setNewBendpoint(insertAt, location);
        return result;
    }

    public static ConnectionBendpointsCommand moveBendpoint(IConnectionSymbol connection, Point newLocation, int bendpointIdx) {
        ConnectionBendpointsCommand result = new ConnectionBendpointsCommand(-2, connection);
        result.setMovedBendpoint(bendpointIdx, newLocation);
        return result;
    }

    public static ConnectionBendpointsCommand removeBendpoint(IConnectionSymbol connection, int bendpointIdx) {
        ConnectionBendpointsCommand result = new ConnectionBendpointsCommand(-3, connection);
        result.setRemovedBendpoint(bendpointIdx);
        return result;
    }

    public static ConnectionBendpointsCommand removeAllBendpoints(IConnectionSymbol connection) {
        return new ConnectionBendpointsCommand(-4, connection);
    }

    ConnectionBendpointsCommand(int cmdKind, IConnectionSymbol target) {
        this.cmdKind = cmdKind;
        this.target = target;
    }

    public void setNewBendpoint(int index, Point location) {
        if (-1 != this.cmdKind) {
            throw new UnsupportedOperationException(Diagram_Messages.EX_MustNotInsertBendpoint);
        }
        this.index = index;
        this.location = location != null ? location.getCopy() : null;
    }

    public void setMovedBendpoint(int index, Point location) {
        if (-2 != this.cmdKind) {
            throw new UnsupportedOperationException(Diagram_Messages.EX_MustNotMoveBendpoint);
        }
        this.index = index;
        this.location = location != null ? location.getCopy() : null;
    }

    public void setRemovedBendpoint(int index) {
        if (-3 != this.cmdKind) {
            throw new UnsupportedOperationException(Diagram_Messages.EX_MustNotRemoveBendpoint);
        }
        this.index = index;
        this.location = null;
    }

    public void execute() {
        if (-2 == this.cmdKind || -3 == this.cmdKind) {
            this.coordinatesBackup = new Coordinates[1];
            this.coordinatesBackup[0] = CarnotWorkflowModelFactory.eINSTANCE.createCoordinates();
            Coordinates c = (Coordinates)this.target.getCoordinates().get(this.index);
            this.coordinatesBackup[0].setXPos(c.getXPos());
            this.coordinatesBackup[0].setYPos(c.getYPos());
        } else if (-4 == this.cmdKind) {
            this.coordinatesBackup = new Coordinates[this.target.getCoordinates().size()];
            this.target.getCoordinates().toArray((Object[])this.coordinatesBackup);
        }
        this.redo();
    }

    public void redo() {
        if (-1 == this.cmdKind) {
            Coordinates newCoordinates = CarnotWorkflowModelPackage.eINSTANCE.getCarnotWorkflowModelFactory().createCoordinates();
            newCoordinates.setXPos((double)this.location.x);
            newCoordinates.setYPos((double)this.location.y);
            this.target.getCoordinates().add(this.index, (Object)newCoordinates);
        } else if (-2 == this.cmdKind) {
            Coordinates coordinates = (Coordinates)this.target.getCoordinates().get(this.index);
            coordinates.setXPos((double)this.location.x);
            coordinates.setYPos((double)this.location.y);
        } else if (-3 == this.cmdKind) {
            this.target.getCoordinates().remove(this.index);
        } else if (-4 == this.cmdKind) {
            this.target.getCoordinates().clear();
        }
    }

    public void undo() {
        if (-1 == this.cmdKind) {
            this.target.getCoordinates().remove(this.index);
        } else if (-2 == this.cmdKind) {
            Coordinates coordinates = (Coordinates)this.target.getCoordinates().get(this.index);
            coordinates.setXPos(this.coordinatesBackup[0].getXPos());
            coordinates.setYPos(this.coordinatesBackup[0].getYPos());
        } else if (-3 == this.cmdKind) {
            this.target.getCoordinates().add(this.index, (Object)this.coordinatesBackup[0]);
        } else if (-4 == this.cmdKind) {
            this.target.getCoordinates().addAll(Arrays.asList(this.coordinatesBackup));
        }
    }
}

