/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IContainedElementCommand;

public abstract class ContainedElementCommand
extends Command
implements IContainedElementCommand {
    private int parentLevel;
    private EObject parent;

    public ContainedElementCommand(int parentLevel) {
        this.parentLevel = parentLevel;
    }

    public EObject getContainer() {
        switch (this.parentLevel) {
            case 2: {
                return this.getModel();
            }
            case 1: {
                return this.getProcess();
            }
        }
        return this.getParent();
    }

    @Override
    public void setParent(EObject parent) {
        this.parent = parent;
    }

    @Override
    public IContainedElementCommand duplicate() {
        try {
            return (IContainedElementCommand)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return this;
        }
    }

    public void dispose() {
        this.parent = null;
    }

    public EObject getParent() {
        return this.parent;
    }

    public ProcessDefinitionType getProcess() {
        if (this.getParent() == null) {
            return null;
        }
        return ModelUtils.findContainingProcess((EObject)this.getParent());
    }

    public ModelType getModel() {
        if (this.getParent() == null) {
            return null;
        }
        return ModelUtils.findContainingModel((EObject)this.getParent());
    }

    public int getParentLevel() {
        return this.parentLevel;
    }
}

