/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;

public class CreateMetaTypeCommand
extends CreateModelElementCommand {
    private ConfigurationElement config;
    private EStructuralFeature[] features;

    public CreateMetaTypeCommand(IConfigurationElement config, EClass eClass, EStructuralFeature[] features) {
        this(config == null ? null : new ConfigurationElement(config), eClass, features);
    }

    public CreateMetaTypeCommand(ConfigurationElement config, EClass eClass, EStructuralFeature[] features) {
        super(2, null, eClass);
        this.config = config;
        this.features = features;
    }

    @Override
    protected IModelElement createModelElement() {
        IMetaType metaType = null;
        if (this.config != null) {
            String id = this.config.getAttribute("id");
            if (ModelUtils.findIdentifiableElement((EObject)this.getModel(), (EStructuralFeature)this.getContainingFeature(), (String)id) == null) {
                metaType = (IMetaType)super.createModelElement();
                metaType.setId(this.config.getAttribute("id"));
                metaType.setName(this.config.getAttribute("name"));
                metaType.setIsPredefined(true);
                int i = 0;
                while (i < this.features.length) {
                    EFactory dataFactory = this.features[i].getEType().getEPackage().getEFactoryInstance();
                    String attribute = this.config.getAttribute(this.features[i].getName());
                    if (attribute != null) {
                        metaType.eSet(this.features[i], dataFactory.createFromString((EDataType)this.features[i].getEType(), attribute));
                    }
                    ++i;
                }
                EList attributes = metaType.getAttribute();
                ConfigurationElement[] elements = this.config.getChildren("attribute");
                CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
                int i2 = 0;
                while (i2 < elements.length) {
                    AttributeType attr = factory.createAttributeType();
                    attr.setName(elements[i2].getAttribute("name"));
                    attr.setType(elements[i2].getAttribute("type"));
                    attr.setValue(elements[i2].getAttribute("value"));
                    attributes.add(attr);
                    ++i2;
                }
            }
        }
        return metaType;
    }
}

