/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.createUtils.CreateModelElementUtil;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ContainedElementCommand;
import org.eclipse.ui.PlatformUI;

public class CreateModelElementCommand
extends ContainedElementCommand {
    private EClass eClass;
    private IdFactory idFactory;
    private IModelElement modelElement;

    public CreateModelElementCommand(int parentLevel, IdFactory idFactory, EClass eClass) {
        super(parentLevel);
        this.idFactory = idFactory;
        this.eClass = eClass;
    }

    public void execute() {
        this.modelElement = this.createModelElement();
        this.redo();
    }

    public boolean canExecute() {
        return this.getContainingFeature() != null;
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public IModelElement getModelElement() {
        return this.modelElement;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    protected IModelElement createModelElement() {
        IModelElement newModelElement = CreateModelElementUtil.createModelElement(this.idFactory, this.eClass, this.getContainer(), this.getModel());
        if (newModelElement instanceof ApplicationType || newModelElement instanceof DataType || newModelElement instanceof IModelParticipant) {
            String visibilityDefault = PlatformUI.getPreferenceStore().getString("multiPackageModelingVisibility");
            if (StringUtils.isEmpty((String)visibilityDefault) || visibilityDefault.equalsIgnoreCase("Public")) {
                AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)newModelElement), (String)"carnot:engine:visibility", (String)"Public");
            } else {
                AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)newModelElement), (String)"carnot:engine:visibility", (String)"Private");
            }
        }
        return newModelElement;
    }

    public void redo() {
        if (this.modelElement != null) {
            List list = (List)this.getContainer().eGet(this.getContainingFeature());
            list.add(this.modelElement);
            if (this.modelElement instanceof ActivityType) {
                AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)this.modelElement), (String)"carnot:pwh:includeTime", (Boolean)(ActivityUtil.isInteractive((ActivityType)((ActivityType)this.modelElement)) ? 1 : 0));
            }
        }
    }

    public void undo() {
        if (this.modelElement != null) {
            List list = (List)this.getContainer().eGet(this.getContainingFeature());
            list.remove(this.modelElement);
        }
    }

    @Override
    public void dispose() {
        this.modelElement = null;
        super.dispose();
    }

    public EStructuralFeature getContainingFeature() {
        return this.getContainer() == null ? null : CommandUtils.findContainmentFeature(this.getContainingFeatureList(), this.eClass);
    }

    protected List<?> getContainingFeatureList() {
        return this.getContainer().eClass().getEStructuralFeatures();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateModelElementCommand)) {
            return false;
        }
        CreateModelElementCommand createModelElementCommand = (CreateModelElementCommand)o;
        if (!this.eClass.equals(createModelElementCommand.eClass)) {
            return false;
        }
        return this.idFactory.equals((Object)createModelElementCommand.idFactory);
    }

    public int hashCode() {
        int result = this.eClass.hashCode();
        result = 29 * result + this.idFactory.hashCode();
        return result;
    }
}

