/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IDiagramCommand;

public abstract class DiagramCommand
extends CreateModelElementCommand
implements IDiagramCommand {
    protected Rectangle location;

    public DiagramCommand(int parentLevel, IdFactory id, EClass eClass) {
        super(parentLevel, id, eClass);
    }

    public PoolSymbol getPool() {
        EObject parent = this.getParent();
        if (parent instanceof PoolSymbol) {
            return (PoolSymbol)parent;
        }
        if (parent instanceof LaneSymbol) {
            return ((LaneSymbol)parent).getParentPool();
        }
        if (parent instanceof DiagramType && parent.eContainer() instanceof ProcessDefinitionType) {
            return DiagramUtil.getDefaultPool((DiagramType)((DiagramType)parent));
        }
        return null;
    }

    public DiagramType getDiagram() {
        DiagramType diagram = null;
        if (this.getParent() instanceof ISymbolContainer) {
            ISymbolContainer container = (ISymbolContainer)this.getParent();
            if (container instanceof LaneSymbol) {
                container = ((LaneSymbol)container).getParentPool();
            }
            if (container instanceof GroupSymbolType) {
                container = ModelUtils.findContainingDiagram((IGraphicalObject)((GroupSymbolType)container));
            }
            diagram = container instanceof PoolSymbol ? ((PoolSymbol)container).getDiagram() : (DiagramType)container;
        }
        return diagram;
    }

    @Override
    public void setLocation(Rectangle location) {
        this.location = location;
    }

    @Override
    public Rectangle getLocation() {
        return this.location;
    }

    @Override
    public void dispose() {
        this.location = null;
        super.dispose();
    }

    @Override
    public EObject getContainer() {
        PoolSymbol defaultPool;
        DiagramType container = null;
        switch (this.getParentLevel()) {
            case 4: {
                container = this.getDiagram();
                break;
            }
            case 3: {
                container = this.getPool();
                if (container != null) break;
                container = this.getDiagram();
                break;
            }
            default: {
                container = super.getContainer();
            }
        }
        if (this.getParentLevel() != 4 && container instanceof DiagramType && (defaultPool = DiagramUtil.getDefaultPool((DiagramType)container)) != null) {
            container = defaultPool;
        }
        return container;
    }
}

