/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetSymbolContainerCommand;

public class ModifyConnectionSymbolCommand
extends Command {
    private final SetSymbolContainerCommand symContainerCmd = new SetSymbolContainerCommand();
    private boolean connectSource;
    private INodeSymbol symbol;
    private INodeSymbol symbolBackup;
    private String anchorType;
    private String anchorTypeBackup;
    private IConnectionSymbol connectionSymbol;

    public void setSource(INodeSymbol source) {
        this.symbol = source;
        this.connectSource = true;
    }

    public void setTarget(INodeSymbol target) {
        this.symbol = target;
        this.connectSource = false;
    }

    public void setConnection(IConnectionSymbol connection) {
        EObject container = connection.eContainer();
        if (container instanceof ISymbolContainer) {
            this.setConnection((ISymbolContainer)container, connection);
        }
    }

    public void setConnection(ISymbolContainer container, IConnectionSymbol connection) {
        this.connectionSymbol = connection;
        this.symContainerCmd.setContainer(container, null);
        this.symContainerCmd.setSymbol((IGraphicalObject)connection);
    }

    public void execute() {
        this.symContainerCmd.execute();
        if (this.connectSource) {
            this.symbolBackup = this.connectionSymbol.getSourceNode();
            this.anchorTypeBackup = this.connectionSymbol.getSourceAnchor();
        } else {
            this.symbolBackup = this.connectionSymbol.getTargetNode();
            this.anchorTypeBackup = this.connectionSymbol.getTargetAnchor();
        }
        this.redo();
    }

    public void redo() {
        this.symContainerCmd.redo();
        if (this.connectSource) {
            this.connectionSymbol.setSourceAnchor(this.anchorType);
            this.connectionSymbol.setSourceNode(this.symbol);
        } else {
            this.connectionSymbol.setTargetAnchor(this.anchorType);
            this.connectionSymbol.setTargetNode(this.symbol);
        }
    }

    public void undo() {
        if (this.connectSource) {
            this.connectionSymbol.setSourceAnchor(this.anchorTypeBackup);
            this.connectionSymbol.setSourceNode(this.symbolBackup);
        } else {
            this.connectionSymbol.setTargetAnchor(this.anchorTypeBackup);
            this.connectionSymbol.setTargetNode(this.symbolBackup);
        }
        this.symContainerCmd.undo();
    }

    public void setAnchorType(String anchorType) {
        this.anchorType = anchorType;
    }
}

