/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;

public class MoveSymbolCommandUtils {
    private static final Comparator X_AXIS_RECT_COMPARATOR = new XAxisRectangleComparator();

    public static boolean isSymbolCollision(List changedParts, EditPart host, EditPart target, Object constraint) {
        boolean noCollision = true;
        HashSet<IFigure> changedFigures = new HashSet<IFigure>(changedParts.size());
        for (Object part : changedParts) {
            if (!(part instanceof GraphicalEditPart)) continue;
            changedFigures.add(((GraphicalEditPart)part).getFigure());
        }
        if (target instanceof AbstractNodeSymbolEditPart && host instanceof AbstractGraphicalEditPart) {
            IFigure hostFigure = ((AbstractGraphicalEditPart)host).getFigure();
            ArrayList<Rectangle> xDropAreas = new ArrayList<Rectangle>(hostFigure.getChildren().size());
            for (IFigure childFigure : hostFigure.getChildren()) {
                if (changedFigures.contains(childFigure)) continue;
                xDropAreas.add(childFigure.getBounds());
            }
            Collections.sort(xDropAreas, X_AXIS_RECT_COMPARATOR);
            IFigure targetFigure = ((GraphicalEditPart)target).getFigure();
            Rectangle bounds = ((Rectangle)constraint).getCopy();
            Dimension min = targetFigure.getMinimumSize();
            Dimension max = targetFigure.getMaximumSize();
            if (-1 == bounds.width) {
                bounds.width = Math.min(max.width, Math.max(targetFigure.getBounds().width, min.width));
            }
            if (-1 == bounds.height) {
                bounds.height = Math.min(max.height, Math.max(targetFigure.getBounds().height, min.height));
            }
            for (Rectangle area : xDropAreas) {
                if (area.right() < bounds.x) continue;
                if (bounds.right() < area.x) break;
                noCollision &= !bounds.intersects(area);
            }
        }
        return !noCollision;
    }

    private static class XAxisRectangleComparator
    implements Comparator {
        private XAxisRectangleComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Rectangle) || !(o2 instanceof Rectangle)) {
                throw new ClassCastException(Diagram_Messages.EX_CLASSCAST_ExpectionCompareRectangles);
            }
            Rectangle lhs = (Rectangle)o1;
            Rectangle rhs = (Rectangle)o2;
            if (lhs.x != rhs.x) {
                return lhs.x < rhs.x ? -1 : 1;
            }
            if (lhs.width != rhs.width) {
                return lhs.width < rhs.width ? -1 : 1;
            }
            return 0;
        }
    }
}

