/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.ActivitySymbolFigure;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteNodeSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.ui.PlatformUI;

public class SetActivityControlFlowCmd
extends Command {
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private final ActivityType activity;
    private final FlowControlType flowControlAspect;
    private final JoinSplitType newBehavior;
    private CompoundCommand cmds;
    private WorkflowModelEditor editor;

    public SetActivityControlFlowCmd(WorkflowModelEditor editor, ActivityType activity, FlowControlType flowControlAspect, JoinSplitType newBehavior) {
        this.activity = activity;
        this.flowControlAspect = flowControlAspect;
        this.newBehavior = newBehavior;
        this.editor = editor;
    }

    public boolean canExecute() {
        this.cmds = new CompoundCommand();
        if (!ActivityUtil.hasEndEvent((ActivityType)this.activity) && FlowControlType.SPLIT_LITERAL.equals((Object)this.flowControlAspect) || !ActivityUtil.hasStartEvent((ActivityType)this.activity) && FlowControlType.JOIN_LITERAL.equals((Object)this.flowControlAspect)) {
            if (!this.getCurrentBehavior(this.activity, this.flowControlAspect).equals((Object)this.newBehavior)) {
                WorkflowModelEditor editor = this.getWorkflowModelEditor();
                DiagramEditorPage diagramEditorPage = (DiagramEditorPage)editor.getCurrentPage();
                DiagramType diagram = diagramEditorPage.getDiagram();
                List activitySymbols = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), null);
                this.createSetJoinSplitTypeCmd(this.cmds, this.activity, this.flowControlAspect, this.newBehavior);
                for (ActivitySymbolType symbol : this.activity.getActivitySymbols()) {
                    if (!activitySymbols.contains(symbol)) continue;
                    if (JoinSplitType.NONE_LITERAL.equals((Object)this.newBehavior)) {
                        this.createRemoveGatewayCmds(this.cmds, symbol, this.flowControlAspect);
                        continue;
                    }
                    this.createAddGatewayCmds(this.cmds, symbol, this.flowControlAspect);
                }
            } else {
                this.cmds.add((Command)UnexecutableCommand.INSTANCE);
            }
        }
        return super.canExecute() && this.cmds.canExecute();
    }

    private WorkflowModelEditor getWorkflowModelEditor() {
        return this.editor == null ? (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() : this.editor;
    }

    public void execute() {
        this.cmds.execute();
    }

    public void redo() {
        this.cmds.redo();
    }

    public void undo() {
        this.cmds.undo();
    }

    private void createSetJoinSplitTypeCmd(CompoundCommand cmds, ActivityType activity, FlowControlType flowType, JoinSplitType newBehavior) {
        Object feature = FlowControlType.JOIN_LITERAL.equals((Object)flowType) ? PKG_CWM.getActivityType_Join() : (FlowControlType.SPLIT_LITERAL.equals((Object)flowType) ? PKG_CWM.getActivityType_Split() : null);
        if (feature != null) {
            cmds.add((Command)new SetValueCmd((EObject)activity, (EStructuralFeature)feature, (Object)newBehavior));
        }
    }

    private JoinSplitType getCurrentBehavior(ActivityType activity, FlowControlType flowType) {
        JoinSplitType result = FlowControlType.JOIN_LITERAL.equals((Object)flowType) ? activity.getJoin() : (FlowControlType.SPLIT_LITERAL.equals((Object)flowType) ? activity.getSplit() : null);
        return result != null ? result : JoinSplitType.NONE_LITERAL;
    }

    private GatewaySymbol findGateway(ActivitySymbolType symbol, FlowControlType flowType) {
        EList gatewaySymbols = symbol.getGatewaySymbols();
        for (GatewaySymbol gateway : gatewaySymbols) {
            if (!flowType.equals((Object)gateway.getFlowKind())) continue;
            return gateway;
        }
        return null;
    }

    private void createAddGatewayCmds(CompoundCommand cmds, ActivitySymbolType activitySymbol, FlowControlType flowType) {
        GatewaySymbol gateway = this.findGateway(activitySymbol, flowType);
        if (gateway == null) {
            DiagramType diagram;
            int deltaY;
            int symbolHeight;
            gateway = CarnotWorkflowModelFactory.eINSTANCE.createGatewaySymbol();
            ActivitySymbolFigure[] figure = new ActivitySymbolFigure[1];
            int symbolWidth = activitySymbol.getWidth();
            if (symbolWidth < 0) {
                symbolWidth = this.getActivitySymbolFigure((ActivitySymbolFigure[])figure, (ActivityType)activitySymbol.getActivity()).getPreferredSize().width;
            }
            if ((symbolHeight = activitySymbol.getHeight()) < 0) {
                symbolHeight = this.getActivitySymbolFigure((ActivitySymbolFigure[])figure, (ActivityType)activitySymbol.getActivity()).getPreferredSize().height;
            }
            int size = 40;
            WorkflowModelEditor editor = this.getWorkflowModelEditor();
            DiagramEditorPage diagramEditorPage = (DiagramEditorPage)editor.getCurrentPage();
            EditPart part = diagramEditorPage.findEditPart(activitySymbol);
            Dimension newSize = SnapGridUtils.getSnapDimension(new Dimension(size, size), (AbstractGraphicalEditPart)part.getParent(), 2, false);
            newSize.width += 2;
            newSize.height += 2;
            if (SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)part.getParent()) != null) {
                size = newSize.width;
            }
            int centerX = Math.round((2L * activitySymbol.getXPos() + (long)symbolWidth) / 2L);
            int centerY = Math.round((2L * activitySymbol.getYPos() + (long)symbolHeight) / 2L);
            boolean isVertical = DiagramPlugin.isVerticalModelling((IGraphicalObject)activitySymbol);
            int deltaX = isVertical ? 0 : Math.round(symbolWidth / 2) + size;
            int n = deltaY = isVertical ? Math.round(symbolHeight / 2) + size : 0;
            if (FlowControlType.JOIN_LITERAL.equals((Object)flowType)) {
                deltaX = -deltaX;
                deltaY = -deltaY;
            }
            int x = centerX + deltaX - size / 2;
            int y = centerY + deltaY - size / 2;
            Point newLocation = new Point(x, y);
            Rectangle newBounds = new Rectangle(newLocation, newSize);
            Point setLocation = SnapGridUtils.getSnapLocation((AbstractGraphicalEditPart)part.getParent(), (AbstractNodeSymbolEditPart)part, new PrecisionRectangle(newBounds), null, null);
            gateway.setXPos((long)setLocation.x);
            gateway.setYPos((long)setLocation.y);
            gateway.setWidth(size);
            gateway.setHeight(size);
            gateway.setFlowKind(flowType);
            EObject container = activitySymbol.eContainer();
            if (container instanceof GroupSymbolType) {
                while (container instanceof GroupSymbolType) {
                    container = container.eContainer();
                }
            }
            cmds.add((Command)new SetValueCmd(container, (EStructuralFeature)PKG_CWM.getISymbolContainer_GatewaySymbol(), (Object)gateway));
            cmds.add((Command)new SetValueCmd((EObject)gateway, (EStructuralFeature)PKG_CWM.getGatewaySymbol_ActivitySymbol(), (Object)activitySymbol));
            if (FlowControlType.JOIN_LITERAL.equals((Object)flowType)) {
                this.createSetTargetSymbolCmds(cmds, (List<TransitionConnectionType>)activitySymbol.getInTransitions(), (IFlowObjectSymbol)gateway);
                this.createAddPseudoTransitionCmds(cmds, this.getSymbolContainer(activitySymbol), (IFlowObjectSymbol)gateway, (IFlowObjectSymbol)activitySymbol);
            } else if (FlowControlType.SPLIT_LITERAL.equals((Object)flowType)) {
                this.createSetSourceSymbolCmds(cmds, (List<TransitionConnectionType>)activitySymbol.getOutTransitions(), (IFlowObjectSymbol)gateway);
                this.createAddPseudoTransitionCmds(cmds, this.getSymbolContainer(activitySymbol), (IFlowObjectSymbol)activitySymbol, (IFlowObjectSymbol)gateway);
            }
            if (part != null && (diagram = ModelUtils.findContainingDiagram((IGraphicalObject)activitySymbol)).getMode().equals((Object)DiagramModeType.MODE_450_LITERAL)) {
                EditPart host = part.getParent();
                while (!(host instanceof AbstractSwimlaneEditPart) && host != null) {
                    host = host.getParent();
                }
                if (host instanceof AbstractSwimlaneEditPart) {
                    final AbstractSwimlaneEditPart hostEditPart = (AbstractSwimlaneEditPart)host;
                    cmds.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.resizeLane(hostEditPart);
                        }
                    });
                    cmds.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.reorderSiblings((EditPart)hostEditPart, null);
                        }
                    });
                }
            }
        }
    }

    private ISymbolContainer getSymbolContainer(ActivitySymbolType symbol) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)symbol);
        PoolSymbol defaultPool = DiagramUtil.getDefaultPool((DiagramType)diagram);
        return defaultPool == null ? diagram : defaultPool;
    }

    private void createRemoveGatewayCmds(CompoundCommand cmds, ActivitySymbolType symbol, FlowControlType flowType) {
        ISymbolContainer diagram = this.getSymbolContainer(symbol);
        EList gateways = symbol.getGatewaySymbols();
        for (GatewaySymbol gateway : gateways) {
            if (!flowType.equals((Object)gateway.getFlowKind())) continue;
            if (FlowControlType.JOIN_LITERAL.equals((Object)flowType)) {
                this.createSetTargetSymbolCmds(cmds, (List<TransitionConnectionType>)gateway.getInTransitions(), (IFlowObjectSymbol)symbol);
                this.removeTransitionConnections(cmds, diagram, (List<TransitionConnectionType>)gateway.getOutTransitions());
            } else if (FlowControlType.SPLIT_LITERAL.equals((Object)flowType)) {
                this.createSetSourceSymbolCmds(cmds, (List<TransitionConnectionType>)gateway.getOutTransitions(), (IFlowObjectSymbol)symbol);
                this.removeTransitionConnections(cmds, diagram, (List<TransitionConnectionType>)gateway.getInTransitions());
            }
            cmds.add((Command)new SetValueCmd((EObject)gateway, (EStructuralFeature)PKG_CWM.getGatewaySymbol_ActivitySymbol(), null));
            cmds.add((Command)new DeleteNodeSymbolCmd((INodeSymbol)gateway));
        }
    }

    private ActivitySymbolFigure getActivitySymbolFigure(ActivitySymbolFigure[] figure, ActivityType activity) {
        if (figure[0] == null) {
            figure[0] = new ActivitySymbolFigure();
            figure[0].setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            if (activity != null) {
                if (activity.getName() != null) {
                    figure[0].setName(activity.getName());
                } else if (activity.getId() != null) {
                    figure[0].setName(activity.getId());
                }
                figure[0].setIconPath(this.getIconFactory().getIconFor((EObject)activity));
            }
            figure[0].validate();
        }
        return figure[0];
    }

    private IconFactory getIconFactory() {
        WorkflowModelEditor editor = this.getWorkflowModelEditor();
        return editor == null ? IconFactory.getDefault() : editor.getIconFactory();
    }

    private void createAddPseudoTransitionCmds(CompoundCommand cmds, ISymbolContainer diagram, IFlowObjectSymbol source, IFlowObjectSymbol target) {
        TransitionConnectionType newTS = CarnotWorkflowModelFactory.eINSTANCE.createTransitionConnectionType();
        newTS.setSourceAnchor("center");
        newTS.setTargetAnchor("center");
        cmds.add((Command)new SetValueCmd((EObject)diagram, (EStructuralFeature)PKG_CWM.getISymbolContainer_TransitionConnection(), (Object)newTS));
        cmds.add((Command)new SetValueCmd((EObject)newTS, (EStructuralFeature)PKG_CWM.getTransitionConnectionType_SourceActivitySymbol(), (Object)source));
        cmds.add((Command)new SetValueCmd((EObject)newTS, (EStructuralFeature)PKG_CWM.getTransitionConnectionType_TargetActivitySymbol(), (Object)target));
    }

    private void removeTransitionConnections(CompoundCommand cmds, ISymbolContainer diagram, List<TransitionConnectionType> transitions) {
        for (TransitionConnectionType ts : transitions) {
            cmds.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)ts));
        }
    }

    private void createSetSourceSymbolCmds(CompoundCommand cmds, List<TransitionConnectionType> transitions, IFlowObjectSymbol symbol) {
        for (TransitionConnectionType ts : transitions) {
            cmds.add((Command)new SetValueCmd((EObject)ts, (EStructuralFeature)PKG_CWM.getTransitionConnectionType_SourceActivitySymbol(), (Object)symbol));
        }
    }

    private void createSetTargetSymbolCmds(CompoundCommand cmds, List<TransitionConnectionType> transitions, IFlowObjectSymbol symbol) {
        for (TransitionConnectionType ts : transitions) {
            cmds.add((Command)new SetValueCmd((EObject)ts, (EStructuralFeature)PKG_CWM.getTransitionConnectionType_TargetActivitySymbol(), (Object)symbol));
        }
    }
}

