/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class SetTypeDeclarationIdCommand
extends Command {
    private TypeDeclarationType declaration;
    private ModelType model;
    private String newId;
    private String previousId;
    private boolean duplicateId = false;
    private Command command;

    public SetTypeDeclarationIdCommand(TypeDeclarationType decl, String id) {
        this.declaration = decl;
        this.model = (ModelType)this.declaration.eContainer().eContainer();
        this.previousId = this.declaration.getId();
        this.newId = id;
        ChangeRecorder targetRecorder = new ChangeRecorder();
        targetRecorder.beginRecording(Collections.singleton(this.declaration.eContainer()));
        if (!this.newId.equals(this.previousId)) {
            this.checkDuplicates();
            this.changeId();
            if (!this.duplicateId) {
                this.fixOtherDeclarations();
            }
        }
        final ChangeDescription change = targetRecorder.endRecording();
        targetRecorder.dispose();
        this.command = new Command(){

            public void execute() {
            }

            public void undo() {
                change.applyAndReverse();
            }

            public void redo() {
                change.applyAndReverse();
            }
        };
    }

    public void redo() {
        this.command.redo();
    }

    public void undo() {
        this.command.undo();
    }

    private void checkDuplicates() {
        for (TypeDeclarationType decl : this.model.getTypeDeclarations().getTypeDeclaration()) {
            if (decl.equals(this.declaration) || !decl.getId().equals(this.newId)) continue;
            this.duplicateId = true;
            break;
        }
    }

    private void changeId() {
        ArrayList savedDirectives = new ArrayList();
        savedDirectives.addAll(this.declaration.getSchema().getReferencingDirectives());
        String oldId = this.declaration.getId();
        this.declaration.setId(this.newId);
        if (TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)this.declaration)) {
            XSDTypeDefinition type;
            XSDElementDeclaration element;
            XSDSchema xsdSchema = this.declaration.getSchema();
            String oldTargetNamespace = xsdSchema.getTargetNamespace();
            xsdSchema.setTargetNamespace(TypeDeclarationUtils.computeTargetNamespace((ModelType)ModelUtils.findContainingModel((EObject)this.declaration), (String)this.newId));
            String prefix = TypeDeclarationUtils.computePrefix((String)this.declaration.getId(), xsdSchema.getQNamePrefixToNamespaceMap().keySet());
            xsdSchema.getQNamePrefixToNamespaceMap().put(prefix, xsdSchema.getTargetNamespace());
            ArrayList toRemove = new ArrayList();
            Map prefixes = xsdSchema.getQNamePrefixToNamespaceMap();
            if (oldTargetNamespace != null) {
                for (Map.Entry entry : prefixes.entrySet()) {
                    if (prefix.equals(entry.getKey()) || !oldTargetNamespace.equals(entry.getValue())) continue;
                    toRemove.add((String)entry.getKey());
                }
                int j = 0;
                while (j < toRemove.size()) {
                    prefixes.remove(toRemove.get(j));
                    ++j;
                }
                xsdSchema.eSet((EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_ReferencingDirectives(), savedDirectives);
                TypeDeclarationUtils.updateImports((XSDSchema)xsdSchema, (String)oldTargetNamespace, (String)oldId, (String)this.newId);
            }
            xsdSchema.setSchemaLocation("urn:internal:" + this.newId);
            xsdSchema.eSet((EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_ReferencingDirectives(), savedDirectives);
            XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)this.declaration, (String)this.previousId);
            if (component != null) {
                component.setName(this.newId);
            }
            if (component instanceof XSDElementDeclaration && !(element = (XSDElementDeclaration)component).isElementDeclarationReference() && element.getAnonymousTypeDefinition() == null && (type = element.getTypeDefinition()) != null && type.getSchema() == xsdSchema) {
                type.setName(this.newId);
            }
        }
        HashSet elements = new HashSet();
        XSDTypeDefinition definition = TypeDeclarationUtils.getTypeDefinition((TypeDeclarationsType)this.model.getTypeDeclarations(), (String)this.newId);
        for (TypeDeclarationType decl : ((TypeDeclarationsType)this.declaration.eContainer()).getTypeDeclaration()) {
            TypeDeclarationUtils.findElementsForType((TypeDeclarationType)decl, elements, (String)oldId);
        }
        for (XSDElementDeclaration elementDecl : elements) {
            elementDecl.setTypeDefinition(definition);
        }
        this.declaration.getSchema().eSet((EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_ReferencingDirectives(), savedDirectives);
    }

    private void fixOtherDeclarations() {
        for (TypeDeclarationType decl : this.model.getTypeDeclarations().getTypeDeclaration()) {
            if (decl.equals(this.declaration)) continue;
            XpdlTypeType type = decl.getDataType();
            if (!TypeDeclarationUtils.fixImport((TypeDeclarationType)decl, (String)this.newId, (String)this.previousId) || !(type instanceof SchemaTypeType)) continue;
            TypeDeclarationUtils.updateTypeDefinition((TypeDeclarationType)decl, (String)this.newId, (String)this.previousId);
        }
    }
}

