/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.ArrayList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteAllCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeletePoolCommand;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;

public class DiagramComponentEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteCommand(GroupRequest deleteRequest) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (this.getHost() instanceof LaneEditPart) {
            CompoundCommand compound = new CompoundCommand();
            this.addDeleteLaneCommands(compound, ((LaneEditPart)this.getHost()).getLaneModel());
            DiagramType diagram = null;
            diagram = this.getHost().getModel() instanceof DiagramType ? (DiagramType)this.getHost().getModel() : ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)this.getHost().getModel()));
            if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL)) {
                final AbstractSwimlaneEditPart parent = (AbstractSwimlaneEditPart)this.getHost().getParent();
                compound.add((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        PoolLaneUtils.setResizeFlags(-1);
                        return PoolLaneUtils.reorderLanes(parent, new Integer(4));
                    }
                });
            }
            cmd = compound;
        } else if (this.getHost() instanceof PoolEditPart) {
            PoolSymbol pool = ((PoolEditPart)this.getHost()).getPoolModel();
            CompoundCommand cmdDelPool = new CompoundCommand();
            for (LaneSymbol lane : pool.getChildLanes()) {
                cmdDelPool.add(DeleteAllCommandFactory.createDeleteAllCommand((IModelElement)lane));
            }
            cmdDelPool.add((Command)new DeletePoolCommand(pool));
            cmd = cmdDelPool;
        } else if (this.getHost() instanceof DiagramEditPart) {
            cmd = DeleteAllCommandFactory.createDeleteAllCommand((IModelElement)this.getHost().getModel());
        }
        return cmd;
    }

    private void addDeleteLaneCommands(CompoundCommand compound, LaneSymbol lane) {
        ArrayList children = new ArrayList();
        children.addAll(lane.getChildLanes());
        compound.add(DeleteAllCommandFactory.createDeleteAllCommand((IModelElement)lane));
        int i = 0;
        while (i < children.size()) {
            this.addDeleteLaneCommands(compound, (LaneSymbol)children.get(i));
            ++i;
        }
    }
}

