/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.modeling.core.editors.figures.IFeedbackFigureFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DistributeAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DistributeRequest;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.DragEditPartsTrackerWithExplicitBendpoints;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.ProxyChangeBoundsRequest;

public class NodeSymbolResizableEditPolicy
extends ResizableEditPolicy {
    public EditPart getTargetEditPart(Request request) {
        EditPart result = null;
        if (this.getHost().getModel() instanceof INodeSymbol) {
            INodeSymbol symbol = (INodeSymbol)this.getHost().getModel();
            while (symbol.eContainer() instanceof GroupSymbolType) {
                symbol = (IGraphicalObject)symbol.eContainer();
            }
            if (this.getHost().getModel() != symbol) {
                result = (EditPart)this.getHost().getRoot().getViewer().getEditPartRegistry().get(symbol);
            }
        }
        return result != null ? result : super.getTargetEditPart(request);
    }

    public int getResizeDirections() {
        Object model = this.getHost().getModel();
        if (model instanceof GatewaySymbol || model instanceof StartEventSymbol || model instanceof EndEventSymbol) {
            return 0;
        }
        return super.getResizeDirections();
    }

    protected List createSelectionHandles() {
        ArrayList list = new ArrayList();
        int directions = this.getResizeDirections();
        if (directions == 0) {
            NonResizableHandleKit.addHandles((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list);
        } else if (directions != -1) {
            NodeSymbolResizableEditPolicy.addMoveHandle((GraphicalEditPart)this.getHost(), list);
            if ((directions & 0x10) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
            }
            if ((directions & 0x14) == 20) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)20);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)20);
            }
            if ((directions & 4) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
            }
            if ((directions & 0xC) == 12) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)12);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)12);
            }
            if ((directions & 8) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
            }
            if ((directions & 9) == 9) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)9);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)9);
            }
            if ((directions & 1) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
            }
            if ((directions & 0x11) == 17) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)17);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)17);
            }
        } else {
            NodeSymbolResizableEditPolicy.addHandles((GraphicalEditPart)this.getHost(), list);
        }
        return list;
    }

    static void addMoveHandle(GraphicalEditPart part, List list) {
        list.add(new MyMoveHandle(part));
    }

    static void addHandles(GraphicalEditPart part, List handles) {
        NodeSymbolResizableEditPolicy.addMoveHandle(part, handles);
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 16));
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 20));
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 4));
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 12));
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 8));
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 9));
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 1));
        handles.add(NodeSymbolResizableEditPolicy.createHandle(part, 17));
    }

    static Handle createHandle(GraphicalEditPart owner, int direction) {
        ResizeHandle handle = new ResizeHandle(owner, direction);
        return handle;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ProxyChangeBoundsRequest req = new ProxyChangeBoundsRequest("move children", request);
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        return this.getHost().getParent().getCommand((Request)req);
    }

    public boolean understandsRequest(Request request) {
        if (DistributeAction.REQ_DISTRIBUTE.equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if (DistributeAction.REQ_DISTRIBUTE.equals(request.getType())) {
            return this.getDistributeChildrenCommand((DistributeRequest)request);
        }
        return super.getCommand(request);
    }

    private Command getDistributeChildrenCommand(DistributeRequest request) {
        return this.getResizeCommand(request);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        IFigure figure = this.createFigure((GraphicalEditPart)this.getHost(), null);
        if (figure != null) {
            figure.setBounds(this.getInitialFeedbackBounds());
            this.addFeedback(figure);
        } else {
            figure = super.createDragSourceFeedbackFigure();
        }
        return figure;
    }

    protected IFigure createFigure(GraphicalEditPart part, IFigure parent) {
        IFigure child = null;
        if (part instanceof IFeedbackFigureFactory && (child = ((IFeedbackFigureFactory)part).createFeedbackFigure()) != null) {
            if (parent != null) {
                parent.add(child);
            }
            Rectangle childBounds = part.getFigure().getBounds().getCopy();
            IFigure walker = part.getFigure().getParent();
            while (walker != ((GraphicalEditPart)part.getParent()).getFigure()) {
                walker.translateToParent((Translatable)childBounds);
                walker = walker.getParent();
            }
            child.setBounds(childBounds);
            Iterator i = part.getChildren().iterator();
            while (i.hasNext()) {
                this.createFigure((GraphicalEditPart)i.next(), child);
            }
        }
        return child;
    }

    public static class MyMoveHandle
    extends MoveHandle {
        public MyMoveHandle(GraphicalEditPart owner) {
            super(owner);
        }

        protected DragTracker createDragTracker() {
            DragEditPartsTrackerWithExplicitBendpoints tracker = new DragEditPartsTrackerWithExplicitBendpoints((EditPart)this.getOwner());
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }
}

